#!/usr/bin/env sh
# Forge requires a configured set of both JVM and program arguments.
# Add custom JVM arguments to the user_jvm_args.txt
# Add custom program arguments {such as nogui} to this file in the next line before the "$@" or
#  pass them to this script directly

while true; do
    # Print a message before each restart
    echo "Starting Minecraft server..."
    
    # Run the server
    java @user_jvm_args.txt @libraries/net/minecraftforge/forge/1.19.2-43.5.0/unix_args.txt "$@"
    
    # Print a message if the server crashes
    echo "Server crashed! Restarting in 10 seconds..."
    
    # Wait 10 seconds before restarting (to prevent rapid crash loops)
    sleep 10
done

