/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import cpw.mods.jarhandling.JarMetadata;
import cpw.mods.jarhandling.SecureJar;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.jar.Manifest;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileParser;
import net.minecraftforge.fml.loading.moddiscovery.ModJarMetadata;
import net.minecraftforge.forgespi.language.IConfigurable;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.forgespi.locating.IModLocator;
import net.minecraftforge.forgespi.locating.IModProvider;
import net.minecraftforge.forgespi.locating.ModFileLoadingException;
import org.slf4j.Logger;

public abstract class AbstractModProvider
implements IModProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final String MODS_TOML = "META-INF/mods.toml";
    protected static final String MANIFEST = "META-INF/MANIFEST.MF";

    protected IModLocator.ModFileOrException createMod(Path ... path) {
        return this.createMod(this.getDefaultJarModType(), path);
    }

    protected IModLocator.ModFileOrException createMod(String defaultType, Path ... path) {
        ModFile mod;
        ModJarMetadata mjm = new ModJarMetadata();
        SecureJar sj = SecureJar.from(Manifest::new, jar -> jar.moduleDataProvider().findFile(MODS_TOML).isPresent() ? mjm : JarMetadata.from((SecureJar)jar, (Path[])path), null, (Path[])path);
        String type = sj.moduleDataProvider().getManifest().getMainAttributes().getValue(ModFile.TYPE);
        if (type == null) {
            type = defaultType;
        }
        if (sj.moduleDataProvider().findFile(MODS_TOML).isPresent()) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", new Object[]{MODS_TOML, type, path});
            mod = new ModFile(sj, this, ModFileParser::modsTomlParser);
        } else if (type != null) {
            LOGGER.debug(LogMarkers.SCAN, "Found {} mod of type {}: {}", new Object[]{MANIFEST, type, path});
            mod = new ModFile(sj, this, this::manifestParser, type);
        } else {
            return new IModLocator.ModFileOrException(null, new ModFileLoadingException("Invalid mod file found " + Arrays.toString(path)));
        }
        mjm.setModFile(mod);
        return new IModLocator.ModFileOrException((IModFile)mod, null);
    }

    protected IModFileInfo manifestParser(IModFile mod) {
        Function<String, Optional> cfg = name -> Optional.ofNullable(mod.getSecureJar().moduleDataProvider().getManifest().getMainAttributes().getValue((String)name));
        String license = cfg.apply("LICENSE").orElse("");
        IConfigurable dummy = new IConfigurable(){

            public <T> Optional<T> getConfigElement(String ... key) {
                return Optional.empty();
            }

            public List<? extends IConfigurable> getConfigList(String ... key) {
                return Collections.emptyList();
            }
        };
        return new DefaultModFileInfo(mod, license, dummy);
    }

    public boolean isValid(IModFile modFile) {
        return true;
    }

    protected String getDefaultJarModType() {
        return null;
    }

    private record DefaultModFileInfo(IModFile mod, String license, IConfigurable configurable) implements IModFileInfo,
    IConfigurable
    {
        public <T> Optional<T> getConfigElement(String ... strings) {
            return Optional.empty();
        }

        public List<? extends IConfigurable> getConfigList(String ... strings) {
            return null;
        }

        public List<IModInfo> getMods() {
            return Collections.emptyList();
        }

        public List<IModFileInfo.LanguageSpec> requiredLanguageLoaders() {
            return Collections.emptyList();
        }

        public boolean showAsResourcePack() {
            return false;
        }

        public Map<String, Object> getFileProperties() {
            return Collections.emptyMap();
        }

        public String getLicense() {
            return this.license;
        }

        public IModFile getFile() {
            return this.mod;
        }

        public IConfigurable getConfig() {
            return this.configurable;
        }

        public String moduleName() {
            return this.mod.getSecureJar().name();
        }

        public String versionString() {
            return null;
        }

        public List<String> usesServices() {
            return null;
        }

        @Override
        public String toString() {
            return "IModFileInfo(" + String.valueOf(this.mod.getFilePath()) + ")";
        }
    }
}

