/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.network.forge;

import dev.jeryn.angels.WeepingAngels;
import dev.jeryn.angels.network.MessageC2S;
import dev.jeryn.angels.network.MessageS2C;
import dev.jeryn.angels.network.MessageType;
import dev.jeryn.angels.network.NetworkManager;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkManagerImpl
extends NetworkManager {
    private final SimpleChannel channel;

    public static NetworkManager create(ResourceLocation channelName) {
        return new NetworkManagerImpl(channelName);
    }

    public NetworkManagerImpl(ResourceLocation channelName) {
        super(channelName);
        this.channel = NetworkRegistry.newSimpleChannel((ResourceLocation)channelName, () -> "1.0.0", s -> true, s -> true);
        this.channel.registerMessage(0, ToServer.class, ToServer::toBytes, x$0 -> new ToServer((FriendlyByteBuf)x$0), ToServer::handle, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        this.channel.registerMessage(1, ToClient.class, ToClient::toBytes, x$0 -> new ToClient((FriendlyByteBuf)x$0), ToClient::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    @Override
    public void sendToServer(MessageC2S message) {
        if (!this.toServer.containsValue(message.getType())) {
            WeepingAngels.LOGGER.warn("Message type not registered: " + message.getType().getId());
            return;
        }
        this.channel.sendToServer((Object)new ToServer(message));
    }

    @Override
    public void sendToPlayer(ServerPlayer player, MessageS2C message) {
        if (!this.toClient.containsValue(message.getType())) {
            WeepingAngels.LOGGER.warn("Message type not registered: " + message.getType().getId());
            return;
        }
        this.channel.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ToClient(message));
    }

    public class ToServer {
        private final MessageC2S message;

        public ToServer(MessageC2S message) {
            this.message = message;
        }

        public ToServer(FriendlyByteBuf buf) {
            String msgId = buf.m_130277_();
            if (!NetworkManagerImpl.this.toServer.containsKey(msgId)) {
                WeepingAngels.LOGGER.warn("Unknown message id received on server: " + msgId);
                this.message = null;
                return;
            }
            MessageType type = (MessageType)NetworkManagerImpl.this.toServer.get(msgId);
            this.message = (MessageC2S)type.getDecoder().decode(buf);
        }

        public void toBytes(FriendlyByteBuf buf) {
            buf.m_130070_(this.message.getType().getId());
            this.message.toBytes(buf);
        }

        public static void handle(ToServer msg, Supplier<NetworkEvent.Context> ctx) {
            if (msg.message != null) {
                ctx.get().enqueueWork(msg.message::handle);
            }
            ctx.get().setPacketHandled(true);
        }
    }

    public class ToClient {
        private final MessageS2C message;

        public ToClient(MessageS2C message) {
            this.message = message;
        }

        public ToClient(FriendlyByteBuf buf) {
            String msgId = buf.m_130277_();
            if (!NetworkManagerImpl.this.toClient.containsKey(msgId)) {
                WeepingAngels.LOGGER.warn("Unknown message id received on client: " + msgId);
                this.message = null;
                return;
            }
            MessageType type = (MessageType)NetworkManagerImpl.this.toClient.get(msgId);
            this.message = (MessageS2C)type.getDecoder().decode(buf);
        }

        public void toBytes(FriendlyByteBuf buf) {
            buf.m_130070_(this.message.getType().getId());
            this.message.toBytes(buf);
        }

        public static void handle(ToClient msg, Supplier<NetworkEvent.Context> ctx) {
            if (msg.message != null) {
                ctx.get().enqueueWork(msg.message::handle);
            }
            ctx.get().setPacketHandled(true);
        }
    }
}

