/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.forge;

import dev.jeryn.angels.WAConfiguration;
import dev.jeryn.angels.WeepingAngels;
import dev.jeryn.angels.common.WAEntities;
import dev.jeryn.angels.common.entity.angel.WeepingAngel;
import dev.jeryn.angels.common.entity.angel.ai.AngelVariant;
import dev.jeryn.angels.data.forge.AngelItemTags;
import dev.jeryn.angels.data.forge.BiomeTagsProvider;
import dev.jeryn.angels.data.forge.BlockTags;
import dev.jeryn.angels.data.forge.EnglishLang;
import dev.jeryn.angels.data.forge.EntityTypeTags;
import dev.jeryn.angels.data.forge.LootProvider;
import dev.jeryn.angels.data.forge.ModelProviderBlock;
import dev.jeryn.angels.data.forge.ModelProviderItem;
import dev.jeryn.angels.data.forge.RecipeProvider;
import dev.jeryn.angels.data.forge.SoundProvider;
import dev.jeryn.angels.data.forge.WABiomeMods;
import dev.jeryn.angels.data.forge.biome.AddAngelSpawns;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.StartupMessageManager;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;

@Mod(value="weeping_angels")
public class WeepingAngelsForge {
    public WeepingAngelsForge() {
        WeepingAngels.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)WAConfiguration.CONFIG_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)WAConfiguration.CLIENT_SPEC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onAttributeAssign);
        modEventBus.addListener(this::onGatherData);
        modEventBus.addListener(this::spawns);
        MinecraftForge.EVENT_BUS.register((Object)this);
        DeferredRegister serializers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"weeping_angels");
        serializers.register(modEventBus);
        serializers.register(AddAngelSpawns.WEEPING_ANGEL_SPAWNS.m_135815_(), AddAngelSpawns::makeCodec);
        StartupMessageManager.addModMessage((String)"Don't Blink!");
    }

    public void spawns(SpawnPlacementRegisterEvent spawnPlacementRegisterEvent) {
        spawnPlacementRegisterEvent.register(WAEntities.WEEPING_ANGEL.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_219013_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    public void onGatherData(GatherDataEvent e) {
        DataGenerator generator = e.getGenerator();
        ExistingFileHelper existingFileHelper = e.getExistingFileHelper();
        generator.m_236039_(true, (DataProvider)new EnglishLang(generator));
        generator.m_236039_(true, (DataProvider)new ModelProviderItem(generator, existingFileHelper));
        generator.m_236039_(true, (DataProvider)new ModelProviderBlock(generator, existingFileHelper));
        generator.m_236039_(true, (DataProvider)new LootProvider(generator));
        generator.m_236039_(true, (DataProvider)new BiomeTagsProvider(generator, existingFileHelper));
        generator.m_236039_(true, (DataProvider)new WABiomeMods(generator));
        generator.m_236039_(true, (DataProvider)new RecipeProvider(generator));
        generator.m_236039_(true, (DataProvider)new SoundProvider(generator, existingFileHelper));
        generator.m_236039_(true, (DataProvider)new BlockTags(generator, existingFileHelper));
        generator.m_236039_(true, (DataProvider)new EntityTypeTags(generator, existingFileHelper));
        generator.m_236039_(true, (DataProvider)new AngelItemTags(generator, new BlockTags(generator, existingFileHelper), existingFileHelper));
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        AngelVariant.init();
    }

    public void onAttributeAssign(EntityAttributeCreationEvent event) {
        event.put(WAEntities.WEEPING_ANGEL.get(), WeepingAngel.createAttributes().m_22265_());
    }
}

