/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.data.forge.biome;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.jeryn.angels.WAEntitySpawns;
import dev.jeryn.angels.common.WAEntities;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public record AddAngelSpawns(HolderSet<Biome> biomes) implements BiomeModifier
{
    public static final ResourceLocation WEEPING_ANGEL_SPAWNS = new ResourceLocation("weeping_angels", "spawns/weeping_angels");
    private static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)WEEPING_ANGEL_SPAWNS, (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"weeping_angels");

    public static Codec<AddAngelSpawns> makeCodec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)Biome.f_47432_.fieldOf("biomes").forGetter(AddAngelSpawns::biomes)).apply((Applicative)builder, AddAngelSpawns::new));
    }

    public void modify(Holder<Biome> biomeHolder, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        Biome biome = (Biome)biomeHolder.get();
        if (phase == BiomeModifier.Phase.ADD && WAEntitySpawns.canSpawnInThisBiome(biome)) {
            builder.getMobSpawnSettings().m_48376_(WAEntitySpawns.getSpawnType(biome), new MobSpawnSettings.SpawnerData(WAEntities.WEEPING_ANGEL.get(), WAEntitySpawns.getSpawnWeight(biome).intValue(), WAEntitySpawns.getSpawnMin(biome).intValue(), WAEntitySpawns.getSpawnMax(biome).intValue()));
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SERIALIZER.get();
    }
}

