/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.data.forge;

import dev.jeryn.angels.WAConfiguration;
import dev.jeryn.angels.common.WAConstants;
import dev.jeryn.angels.common.WAEntities;
import dev.jeryn.angels.common.WASounds;
import dev.jeryn.angels.common.blocks.WABlocks;
import dev.jeryn.angels.common.entity.angel.ai.AngelVariant;
import dev.jeryn.angels.common.items.WAItems;
import dev.jeryn.angels.util.WADamageSources;
import net.minecraft.data.DataGenerator;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.data.LanguageProvider;

public class EnglishLang
extends LanguageProvider {
    public EnglishLang(DataGenerator dataGenerator) {
        super(dataGenerator, "weeping_angels", "en_us");
    }

    protected void addTranslations() {
        this.add(WAConstants.ANOMALIES_DETECTED, "Anomalies Detected: %s");
        this.add(WAConstants.CHISEL_POSE, "* Interact to change pose");
        this.add(WAConstants.CHISEL_VARIANT, "* Sneak + Interact to change variant");
        this.add(WAConstants.ANGEL_EMOTION, "Emotion");
        this.add(WAConstants.ANGEL_VARIANT, "Variant");
        this.add(WAConstants.ANGEL_POSES, "Pose");
        this.addAngelVariant(AngelVariant.BASALT, "Alice (Basalt)");
        this.addAngelVariant(AngelVariant.STONE, "Alice (Stone)");
        this.addAngelVariant(AngelVariant.COPPER, "Alice (Copper Ore)");
        this.addAngelVariant(AngelVariant.DIAMOND, "Alice (Diamond Ore)");
        this.addAngelVariant(AngelVariant.EMERALD, "Alice (Emerald Ore)");
        this.addAngelVariant(AngelVariant.GOLD, "Alice (Gold Ore)");
        this.addAngelVariant(AngelVariant.IRON, "Alice (Iron Ore)");
        this.addAngelVariant(AngelVariant.LAPIS_LAZULI, "Alice (Lapis Ore)");
        this.addAngelVariant(AngelVariant.MOSSY, "Alice (Mossy)");
        this.addAngelVariant(AngelVariant.QUARTZ, "Alice (Quartz)");
        this.addAngelVariant(AngelVariant.RUSTED, "Alice (Rusted)");
        this.addAngelVariant(AngelVariant.RUSTED_NO_ARM, "Alice (Rusted - No Arm)");
        this.addAngelVariant(AngelVariant.RUSTED_NO_HEAD, "Alice (Rusted - No Head)");
        this.addAngelVariant(AngelVariant.RUSTED_NO_WING, "Alice (Rusted - Missing Wing)");
        this.addAngelVariant(AngelVariant.DIRT, "Alice (Dirt)");
        this.addAngelVariant(AngelVariant.GAS_RUSTED, "SpareTime (Rusted)");
        this.addAngelVariant(AngelVariant.GAS_STONE, "SpareTime (Stone)");
        this.addAngelVariant(AngelVariant.DOCTOR, "The Doctor");
        this.addAngelVariant(AngelVariant.A_DIZZLE, "a_dizzle");
        this.add(WAEntities.WEEPING_ANGEL.get(), "Weeping Angel");
        this.add(WABlocks.CHRONODYNE_GENERATOR.get(), "Chronodyne Generator");
        this.add(WABlocks.COFFIN.get(), "Coffin");
        this.add(WABlocks.STATUE.get(), "Statue");
        this.add(WABlocks.PLINTH.get(), "Plinth");
        this.add(WABlocks.SNOW_ANGEL.get(), "Snow Angel");
        this.add(WAItems.TIMEY_WIMEY_DETECTOR.get(), "Timey Wimey Detector");
        this.add(WAItems.ANGEL_SPAWNER.get(), "Spawn Weeping Angel");
        this.add(WAItems.CHRONODYNE_GENERATOR.get(), "Chronodyne Generator");
        this.add(WAItems.CHISEL.get(), "Chisel");
        this.add(WAItems.DISC_SALLY.get(), "Music Disc");
        this.add(WAItems.DISC_TIME_PREVAILS.get(), "Music Disc");
        this.add("item.weeping_angels.music_disc_sally.desc", "Sally Sparrow");
        this.add("item.weeping_angels.music_disc_time_prevails.desc", "Time Prevails");
        this.add("gui.statue.appearance", "Chisel Statue");
        this.add("gui.chisel.confirm", "Chisel");
        this.add("itemGroup.weeping_angels", "Weeping Angels");
        this.add("itemGroup.weeping_angels.weeping_angels", "Weeping Angels");
        this.add(WADamageSources.GENERATOR, "%s was sucked into the vortex...");
        this.add(WADamageSources.PUNCH_STONE, "%s punched stone too hard...");
        this.add(WADamageSources.SNAPPED_NECK, "%s had their neck snapped by a Weeping Angel");
        this.addSound(WASounds.ANGEL_MOCKING.get(), "Angel mocks");
        this.addSound(WASounds.BLOW.get(), "Angel blows");
        this.addSound(WASounds.DING.get(), "Ding!");
        this.addSound(WASounds.DISC_SALLY.get(), "Sally");
        this.addSound(WASounds.DISC_TIME_PREVAILS.get(), "Time prevails");
        this.addSound(WASounds.LOCKED.get(), "Locked");
        this.addSound(WASounds.KNOCK.get(), "Knocking");
        this.addSound(WASounds.TARDIS_TAKEOFF.get(), "Tardis Takeoff");
        this.addSound(WASounds.PROJECTOR.get(), "Whirr");
        this.addSound(WASounds.CRUMBLING.get(), "Crumbling");
        this.addConfig((ForgeConfigSpec.ConfigValue)WAConfiguration.CONFIG.hurtType, "Hurt Type?");
        this.addConfig((ForgeConfigSpec.ConfigValue)WAConfiguration.CONFIG.stalkRange, "Stalk Range");
        this.addConfig((ForgeConfigSpec.ConfigValue)WAConfiguration.CONFIG.teleportChance, "Teleport Chance");
        this.addConfig((ForgeConfigSpec.ConfigValue)WAConfiguration.CONFIG.teleportRange, "Teleport Range");
        this.addConfig(WAConfiguration.CONFIG.bannedDimensions, "Banned Dimensions");
        this.addConfig((ForgeConfigSpec.ConfigValue)WAConfiguration.CONFIG.blockBreaking, "Block Griefing?");
    }

    public void addAngelVariant(AngelVariant angelVariant, String lang) {
        this.add("variant.weeping_angels." + angelVariant.location().m_135815_(), lang);
    }

    public void addSound(SoundEvent soundEvent, String lang) {
        this.add("subtitle.weeping_angels." + soundEvent.m_11660_().m_135815_(), lang);
    }

    public void addConfig(ForgeConfigSpec.ConfigValue waConfiguration, String message) {
        this.add("config.weeping_angels." + waConfiguration.getPath().get(1), message);
    }

    public void add(DamageSource damageSource, String message) {
        this.add("death.attack." + damageSource.m_19385_(), message);
        this.add("death.attack." + damageSource.m_19385_() + ".player", message);
    }
}

