/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.common.items;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SpawnerItem
extends Item {
    private final Supplier<EntityType<? extends Mob>> defaultType;

    public SpawnerItem(Supplier<EntityType<? extends Mob>> pDefaultType, Item.Properties pProperties) {
        super(pProperties);
        this.defaultType = pDefaultType;
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        BlockEntity blockentity;
        Level level = pContext.m_43725_();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = pContext.m_43722_();
        BlockPos blockpos = pContext.m_8083_();
        Direction direction = pContext.m_43719_();
        BlockState blockstate = level.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50085_) && (blockentity = level.m_7702_(blockpos)) instanceof SpawnerBlockEntity) {
            BaseSpawner basespawner = ((SpawnerBlockEntity)blockentity).m_59801_();
            EntityType<?> entitytype1 = this.getType(itemstack.m_41783_());
            basespawner.m_45462_(entitytype1);
            blockentity.m_6596_();
            level.m_7260_(blockpos, blockstate, blockstate, 3);
            level.m_142346_((Entity)pContext.m_43723_(), GameEvent.f_157792_, blockpos);
            itemstack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        BlockPos blockpos1 = blockstate.m_60812_((BlockGetter)level, blockpos).m_83281_() ? blockpos : blockpos.m_121945_(direction);
        EntityType<?> entitytype = this.getType(itemstack.m_41783_());
        if (entitytype.m_20592_((ServerLevel)level, itemstack, pContext.m_43723_(), blockpos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockpos, blockpos1) && direction == Direction.UP) != null) {
            itemstack.m_41774_(1);
            level.m_142346_((Entity)pContext.m_43723_(), GameEvent.f_157810_, blockpos);
        }
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        BlockHitResult hitresult = SpawnerItem.m_41435_((Level)pLevel, (Player)pPlayer, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hitresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (!(pLevel instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        BlockHitResult blockhitresult = hitresult;
        BlockPos blockpos = blockhitresult.m_82425_();
        if (!(pLevel.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (pLevel.m_7966_(pPlayer, blockpos) && pPlayer.m_36204_(blockpos, blockhitresult.m_82434_(), itemstack)) {
            EntityType<?> entityType = this.getType(itemstack.m_41783_());
            Entity entity = entityType.m_20592_((ServerLevel)pLevel, itemstack, pPlayer, blockpos, MobSpawnType.SPAWN_EGG, false, false);
            if (entity == null) {
                return InteractionResultHolder.m_19098_((Object)itemstack);
            }
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            pLevel.m_220400_((Entity)pPlayer, GameEvent.f_157810_, entity.m_20182_());
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public EntityType<?> getType(CompoundTag pNbt) {
        CompoundTag compoundtag;
        if (pNbt != null && pNbt.m_128425_("EntityTag", 10) && (compoundtag = pNbt.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return EntityType.m_20632_((String)compoundtag.m_128461_("id")).orElse(this.defaultType.get());
        }
        return this.defaultType.get();
    }
}

