/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.common.blocks;

import dev.jeryn.angels.common.blockentity.GeneratorBlockEntity;
import dev.jeryn.angels.common.items.WAItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlock
extends BaseEntityBlock {
    private static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;

    public GeneratorBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties.m_60955_());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)blockEntity;
            if (!generatorBlockEntity.hasSpawned()) {
                return;
            }
            double d = (double)pos.m_123341_() + random.m_188500_();
            double e = (double)pos.m_123342_() + 0.8;
            double f = (double)pos.m_123343_() + random.m_188500_();
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    public BlockState m_5573_(@NotNull BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        FluidState fluid = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)((BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(Mth.m_14107_((double)((double)(context.m_7074_() * 16.0f / 360.0f) + 0.5)) & 0xF))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(fluid.m_205070_(FluidTags.f_13131_)));
    }

    protected void m_7926_(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ROTATION, BlockStateProperties.f_61362_});
    }

    public static boolean isBreakable(LevelAccessor level, BlockPos blockPos) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof GeneratorBlockEntity) {
            GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)blockEntity;
            return !generatorBlockEntity.isActivated();
        }
        return true;
    }

    @NotNull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76145_() : Fluids.f_76191_.m_76145_();
    }

    @NotNull
    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rot.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    @NotNull
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirrorIn.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return BOTTOM_AABB;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof GeneratorBlockEntity) {
                GeneratorBlockEntity generatorBlockEntity = (GeneratorBlockEntity)t;
                generatorBlockEntity.tick(pLevel, blockPos, blockState, generatorBlockEntity);
            }
        };
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return GeneratorBlock.canSupportCenter(level, pos.m_7495_(), Direction.UP);
    }

    public ItemStack m_7397_(BlockGetter level, BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)WAItems.CHRONODYNE_GENERATOR.get());
    }

    public static boolean canSupportCenter(LevelReader level, BlockPos pos, Direction direction) {
        BlockState blockState = level.m_8055_(pos);
        return (direction != Direction.DOWN || !blockState.m_204336_(BlockTags.f_13056_)) && blockState.m_60659_((BlockGetter)level, pos, direction, SupportType.CENTER);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !this.m_7898_(state, (LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        super.m_6861_(pState, pLevel, pPos, pBlock, pFromPos, pIsMoving);
        if (!pLevel.m_5776_() && pLevel.m_46753_(pPos)) {
            this.activateFromPos(pPos, pLevel, true);
        }
    }

    private boolean activateFromPos(BlockPos pos, Level level, boolean activated) {
        GeneratorBlockEntity generatorBlockEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GeneratorBlockEntity && !(generatorBlockEntity = (GeneratorBlockEntity)blockEntity).isActivated()) {
            generatorBlockEntity.setActivated(activated);
            generatorBlockEntity.sendUpdates();
            return true;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (!pLevel.m_5776_()) {
            ItemStack handItem = pPlayer.m_21120_(pHand);
            if (GeneratorBlock.isBreakable((LevelAccessor)pLevel, pPos)) {
                handItem.m_41774_(1);
                this.activateFromPos(pPos, pLevel, true);
                pPlayer.m_6674_(pHand);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GeneratorBlockEntity(pos, state);
    }
}

