/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.client.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.jeryn.angels.common.WAConstants;
import dev.jeryn.angels.common.blockentity.StatueBlockEntity;
import dev.jeryn.angels.common.entity.angel.WeepingAngel;
import dev.jeryn.angels.common.entity.angel.ai.AngelEmotion;
import dev.jeryn.angels.common.entity.angel.ai.AngelVariant;
import dev.jeryn.angels.network.messages.UpdateStatueMessage;
import java.awt.Color;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class ChiselScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("weeping_angels", "textures/ui/menubg.png");
    private static final WeepingAngel weepingAngelFake = new WeepingAngel((Level)Minecraft.m_91087_().f_91073_);
    public static AnimationState POSE_ANIMATION_STATE = new AnimationState();
    private final BlockPos blockPos;
    private final ResourceKey<Level> level;
    private int guiLeft;
    private int guiTop;
    private int xSize = 200;
    private int ySize = 222;

    public ChiselScreen(Component component, BlockPos blockPos, ResourceKey<Level> levelResourceKey) {
        super(component);
        this.blockPos = blockPos;
        this.level = levelResourceKey;
    }

    public void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        CycleButton emotionButton = CycleButton.m_168894_(o -> Component.m_237113_((String)o.getId())).m_168961_((Object[])AngelEmotion.values()).m_168948_((Object)AngelEmotion.ANGRY).m_168936_(this.guiLeft + this.xSize - 125, this.guiTop + 50, 130, 20, (Component)Component.m_237115_((String)WAConstants.ANGEL_EMOTION), (cycleButton, angelEmotion) -> weepingAngelFake.setEmotion((AngelEmotion)((Object)angelEmotion)));
        CycleButton variantCycleButton = CycleButton.m_168894_(o -> Component.m_237115_((String)("variant.weeping_angels." + o.location().m_135815_()))).m_232502_(AngelVariant.VARIANTS.values()).m_168948_((Object)AngelVariant.BASALT).m_168936_(this.guiLeft + this.xSize - 125, this.guiTop + 80, 130, 20, (Component)Component.m_237115_((String)WAConstants.ANGEL_VARIANT), (cycleButton, angelVariant) -> weepingAngelFake.setVariant((AngelVariant)angelVariant));
        CycleButton poseCycleButton = CycleButton.m_168894_(o -> Component.m_237113_((String)o.toString())).m_232502_((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12})).m_168948_((Object)0).m_168936_(this.guiLeft + this.xSize - 125, this.guiTop + 110, 130, 20, (Component)Component.m_237115_((String)WAConstants.ANGEL_POSES), (cycleButton, pose) -> weepingAngelFake.setFakeAnimation((int)pose));
        this.m_142416_((GuiEventListener)emotionButton);
        this.m_142416_((GuiEventListener)variantCycleButton);
        this.m_142416_((GuiEventListener)poseCycleButton);
        BlockEntity blockEntity = Minecraft.m_91087_().f_91073_.m_7702_(this.blockPos);
        if (!(blockEntity instanceof StatueBlockEntity)) {
            Minecraft.m_91087_().m_91152_(null);
            return;
        }
        StatueBlockEntity statueBlockEntity = (StatueBlockEntity)blockEntity;
        weepingAngelFake.setVariant(statueBlockEntity.getVariant());
        weepingAngelFake.setEmotion(statueBlockEntity.getEmotion());
        weepingAngelFake.setFakeAnimation(statueBlockEntity.getAnimation());
        variantCycleButton.m_168892_((Object)statueBlockEntity.getVariant());
        emotionButton.m_168892_((Object)statueBlockEntity.getEmotion());
        poseCycleButton.m_168892_((Object)statueBlockEntity.getAnimation());
        Button chiselButton = new Button(this.guiLeft + this.xSize - 125, this.guiTop + 160, 130, 20, (Component)Component.m_237115_((String)"gui.chisel.confirm"), buttonx -> {
            new UpdateStatueMessage((AngelVariant)variantCycleButton.m_168883_(), (AngelEmotion)((Object)((Object)emotionButton.m_168883_())), (Integer)poseCycleButton.m_168883_(), this.blockPos, this.level).send();
            Minecraft.m_91087_().m_91152_(null);
        });
        this.m_142416_((GuiEventListener)chiselButton);
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        ChiselScreen.m_93133_((PoseStack)poseStack, (int)(this.guiLeft - 30), (int)this.guiTop, (float)0.0f, (float)0.0f, (int)256, (int)256, (int)256, (int)256);
        if (!POSE_ANIMATION_STATE.m_216984_()) {
            POSE_ANIMATION_STATE.m_216977_(12);
        }
        poseStack.m_85836_();
        InventoryScreen.m_98850_((int)(this.guiLeft + 25), (int)(this.guiTop + 160), (int)55, (float)-90.0f, (float)-45.0f, (LivingEntity)weepingAngelFake);
        poseStack.m_85849_();
        this.f_96547_.m_92889_(poseStack, (Component)Component.m_237115_((String)"gui.statue.appearance"), (float)(this.guiLeft - 20), (float)(this.guiTop + 10), Color.BLACK.getRGB());
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
    }
}

