/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.jeryn.angels.client.models.ModelRegistration;
import dev.jeryn.angels.common.blockentity.SnowAngelBlockEntity;
import dev.jeryn.angels.common.blocks.CoffinBlock;
import dev.jeryn.angels.common.entity.angel.ai.AngelEmotion;
import dev.jeryn.angels.common.entity.angel.ai.AngelVariant;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class SnowAngelRenderer
implements BlockEntityRenderer<SnowAngelBlockEntity>,
BlockEntityRendererProvider<SnowAngelBlockEntity> {
    private final ModelPart armModel;
    private final ModelPart bodyModel;
    private final ModelPart headModel;
    private final ModelPart wingsModel;

    public SnowAngelRenderer(BlockEntityRendererProvider.Context context) {
        this.armModel = context.m_173582_(ModelRegistration.SNOW_ARM);
        this.bodyModel = context.m_173582_(ModelRegistration.SNOW_BODY);
        this.headModel = context.m_173582_(ModelRegistration.SNOW_HEAD);
        this.wingsModel = context.m_173582_(ModelRegistration.SNOW_WINGS);
    }

    public static ResourceLocation getTexture(SnowAngelBlockEntity snowAngelBlockEntity) {
        return ModelRegistration.getModelFor(AngelVariant.STONE).texture(AngelEmotion.ANGRY, AngelVariant.STONE);
    }

    public void render(SnowAngelBlockEntity snowAngelBlockEntity, float partialTicks, PoseStack matrixStack, @NotNull MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStack.m_85836_();
        BlockState blockstate = snowAngelBlockEntity.m_58900_();
        float rotation = 22.5f * (float)((Integer)blockstate.m_61143_((Property)CoffinBlock.ROTATION)).intValue();
        switch (snowAngelBlockEntity.getSnowAngelStages()) {
            case ARM: {
                matrixStack.m_85837_(0.5, (double)-1.1f, 0.5);
                matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(rotation));
                this.armModel.m_104306_(matrixStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)SnowAngelRenderer.getTexture(snowAngelBlockEntity))), combinedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case HEAD: {
                matrixStack.m_85837_(0.5, (double)1.6f, 0.5);
                matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(rotation));
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                this.headModel.m_104306_(matrixStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)SnowAngelRenderer.getTexture(snowAngelBlockEntity))), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case BODY: {
                matrixStack.m_85837_(0.5, (double)1.7f, 0.5);
                matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(rotation));
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                this.bodyModel.m_104306_(matrixStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)SnowAngelRenderer.getTexture(snowAngelBlockEntity))), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case WINGS: {
                matrixStack.m_85837_(0.5, 1.5, 0.5);
                matrixStack.m_85845_(Vector3f.f_122224_.m_122240_(rotation));
                matrixStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                this.wingsModel.m_104306_(matrixStack, bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)SnowAngelRenderer.getTexture(snowAngelBlockEntity))), combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
        matrixStack.m_85849_();
    }

    @NotNull
    public BlockEntityRenderer<SnowAngelBlockEntity> m_173570_(@NotNull BlockEntityRendererProvider.Context p_173571_) {
        return new SnowAngelRenderer(p_173571_);
    }
}

