/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.jeryn.angels.client.models.ModelRegistration;
import dev.jeryn.angels.client.models.blockentity.CoffinModel;
import dev.jeryn.angels.client.models.blockentity.TardisModel;
import dev.jeryn.angels.common.blockentity.CoffinBlockEntity;
import dev.jeryn.angels.common.blocks.CoffinBlock;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class CoffinRenderer
implements BlockEntityRenderer<CoffinBlockEntity>,
BlockEntityRendererProvider<CoffinBlockEntity> {
    private static CoffinModel coffinModel;
    private static TardisModel tardisModel;

    public CoffinRenderer(BlockEntityRendererProvider.Context context) {
        coffinModel = new CoffinModel(context.m_173582_(ModelRegistration.COFFIN));
        tardisModel = new TardisModel(context.m_173582_(ModelRegistration.TARDIS));
    }

    public void render(CoffinBlockEntity coffinBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        pPoseStack.m_85836_();
        pPoseStack.m_85837_(0.5, 0.5, 0.5);
        BlockState blockstate = coffinBlockEntity.m_58900_();
        float rotation = 22.5f * (float)((Integer)blockstate.m_61143_((Property)CoffinBlock.ROTATION)).intValue();
        pPoseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
        pPoseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
        if (!((Boolean)coffinBlockEntity.m_58900_().m_61143_((Property)CoffinBlock.UPRIGHT)).booleanValue()) {
            pPoseStack.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
        } else {
            pPoseStack.m_85837_(0.0, -1.0, 0.0);
        }
        if (coffinBlockEntity.getCoffinType().isTardis()) {
            pPoseStack.m_85837_(0.0, 0.5, 0.0);
            pPoseStack.m_85841_(0.7f, 0.7f, 0.7f);
            tardisModel.m_7695_(pPoseStack, pBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)coffinBlockEntity.getCoffinType().getTexture())), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, coffinBlockEntity.getAlpha());
        } else {
            coffinModel.animateTile(coffinBlockEntity);
            coffinModel.m_7695_(pPoseStack, pBufferSource.m_6299_(RenderType.m_110452_((ResourceLocation)coffinBlockEntity.getCoffinType().getTexture())), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        pPoseStack.m_85849_();
    }

    @NotNull
    public BlockEntityRenderer<CoffinBlockEntity> m_173570_(@NotNull BlockEntityRendererProvider.Context context) {
        return new CoffinRenderer(context);
    }
}

