/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;

public class WAEntitySpawns {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File CONFIG_FILE = new File("config/weeping_angels_spawns.json");
    private static Map<ResourceLocation, BiomeSpawnConfig> biomeSpawnConfigs = new HashMap<ResourceLocation, BiomeSpawnConfig>();

    public static void init(MinecraftServer minecraftServer) {
        WAEntitySpawns.loadConfig();
    }

    public static boolean canSpawnInThisBiome(Biome biome) {
        Registry biomeRegistry = BuiltinRegistries.f_123865_;
        if (!biomeSpawnConfigs.containsKey(biomeRegistry.m_7981_((Object)biome))) {
            return false;
        }
        return WAEntitySpawns.biomeSpawnConfigs.get((Object)biomeRegistry.m_7981_((Object)biome)).canSpawnHere;
    }

    public static MobCategory getSpawnType(Biome biome) {
        Registry biomeRegistry = BuiltinRegistries.f_123865_;
        if (!biomeSpawnConfigs.containsKey(biomeRegistry.m_7981_((Object)biome))) {
            return MobCategory.MONSTER;
        }
        return WAEntitySpawns.biomeSpawnConfigs.get((Object)biomeRegistry.m_7981_((Object)biome)).mobCategory;
    }

    public static Integer getSpawnMin(Biome biome) {
        Registry biomeRegistry = BuiltinRegistries.f_123865_;
        if (!biomeSpawnConfigs.containsKey(biomeRegistry.m_7981_((Object)biome))) {
            return 0;
        }
        return WAEntitySpawns.biomeSpawnConfigs.get((Object)biomeRegistry.m_7981_((Object)biome)).minCount;
    }

    public static Integer getSpawnMax(Biome biome) {
        Registry biomeRegistry = BuiltinRegistries.f_123865_;
        if (!biomeSpawnConfigs.containsKey(biomeRegistry.m_7981_((Object)biome))) {
            return 0;
        }
        return WAEntitySpawns.biomeSpawnConfigs.get((Object)biomeRegistry.m_7981_((Object)biome)).maxCount;
    }

    public static Integer getSpawnWeight(Biome biome) {
        Registry biomeRegistry = BuiltinRegistries.f_123865_;
        if (!biomeSpawnConfigs.containsKey(biomeRegistry.m_7981_((Object)biome))) {
            return 0;
        }
        return WAEntitySpawns.biomeSpawnConfigs.get((Object)biomeRegistry.m_7981_((Object)biome)).spawnWeight;
    }

    public static void loadConfig() {
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(CONFIG_FILE);){
                Type type = new TypeToken<Map<String, BiomeSpawnConfig>>(){}.getType();
                Map configMap = (Map)GSON.fromJson((Reader)reader, type);
                for (Map.Entry entry : configMap.entrySet()) {
                    biomeSpawnConfigs.put(new ResourceLocation((String)entry.getKey()), (BiomeSpawnConfig)entry.getValue());
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            WAEntitySpawns.generateDefaultConfig();
        }
    }

    public static void saveConfig() {
        HashMap<String, BiomeSpawnConfig> configMap = new HashMap<String, BiomeSpawnConfig>();
        for (Map.Entry<ResourceLocation, BiomeSpawnConfig> entry : biomeSpawnConfigs.entrySet()) {
            configMap.put(entry.getKey().toString(), entry.getValue());
        }
        try (FileWriter writer = new FileWriter(CONFIG_FILE);){
            GSON.toJson(configMap, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void generateDefaultConfig() {
        Registry biomeRegistry = BuiltinRegistries.f_123865_;
        for (Biome biome : biomeRegistry) {
            boolean canSpawnHere;
            ResourceLocation biomeKey = biomeRegistry.m_7981_((Object)biome);
            boolean isNetherBiome = WAEntitySpawns.isNetherBiome(biomeKey);
            boolean isTardis = WAEntitySpawns.isTardis(biomeKey);
            boolean isWater = WAEntitySpawns.isWater(biomeKey);
            int minCount = 1;
            int maxCount = 4;
            int spawnWeight = 8;
            boolean bl = canSpawnHere = !isTardis && !isWater;
            if (isNetherBiome) {
                minCount = 0;
                maxCount = 1;
                spawnWeight = 1;
            }
            BiomeSpawnConfig config = new BiomeSpawnConfig(MobCategory.MONSTER, minCount, maxCount, spawnWeight, canSpawnHere);
            biomeSpawnConfigs.put(biomeKey, config);
        }
        WAEntitySpawns.saveConfig();
    }

    private static boolean isNetherBiome(ResourceLocation biomeKey) {
        Registry biomeRegistry = BuiltinRegistries.f_123865_;
        return biomeRegistry.m_203431_(BiomeTags.f_207612_).map(tag -> tag.m_203333_(biomeRegistry.m_206081_(ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biomeKey)))).orElse(false);
    }

    private static boolean isWater(ResourceLocation biomeKey) {
        return biomeKey.m_135815_().contains("ocean") || biomeKey.m_135815_().contains("river");
    }

    private static boolean isTardis(ResourceLocation biomeKey) {
        return biomeKey.m_135815_().contains("tardis");
    }

    public static class BiomeSpawnConfig {
        private final MobCategory mobCategory;
        public int minCount;
        public int maxCount;
        public int spawnWeight;
        public boolean canSpawnHere;

        public BiomeSpawnConfig(MobCategory mobCategory, int minCount, int maxCount, int spawnWeight, boolean canSpawnHere) {
            this.minCount = minCount;
            this.maxCount = maxCount;
            this.spawnWeight = spawnWeight;
            this.canSpawnHere = canSpawnHere;
            this.mobCategory = mobCategory;
        }
    }
}

