/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.binarypatcher;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.binarypatcher.Generator;
import net.minecraftforge.binarypatcher.Patcher;

public class ConsoleTool {
    public static final long ZIPTIME = 628041600000L;

    public static void main(String[] args) throws IOException {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT"));
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec cleanO = parser.accepts("clean").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        ArgumentAcceptingOptionSpec prefixO = parser.accepts("prefix").withRequiredArg();
        OptionSpecBuilder packO = parser.accepts("pack200");
        OptionSpecBuilder legacyO = parser.accepts("legacy", "Uses the legacy patch header format, also implies --pack200. NOT RECOMENDED.");
        ArgumentAcceptingOptionSpec createO = parser.acceptsAll(Arrays.asList("dirty", "create")).withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec patchesO = parser.accepts("patches").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec srgO = parser.accepts("srg").withRequiredArg().ofType(File.class);
        ArgumentAcceptingOptionSpec applyO = parser.accepts("apply").withRequiredArg().ofType(File.class);
        OptionSpecBuilder dataO = parser.accepts("data");
        OptionSpecBuilder unpatchedO = parser.accepts("unpatched");
        try {
            boolean pack200;
            OptionSet options = parser.parse(args);
            File output = ((File)options.valueOf((OptionSpec)outputO)).getAbsoluteFile();
            boolean legacy = options.has((OptionSpec)legacyO);
            boolean bl = pack200 = legacy || options.has((OptionSpec)packO);
            if (output.exists() && !output.delete()) {
                ConsoleTool.err("Could not delete output file: " + output);
            }
            if (!output.getParentFile().exists() && !output.getParentFile().mkdirs()) {
                ConsoleTool.err("Could not make output folders: " + output.getParentFile());
            }
            if (options.has((OptionSpec)createO) && options.has((OptionSpec)applyO)) {
                ConsoleTool.err("Cannot specify --apply and --create at the same time!");
            }
            if (options.has((OptionSpec)createO)) {
                if (options.has((OptionSpec)dataO)) {
                    ConsoleTool.err("Connot specify --create/--dirty and --data at the same time!");
                }
                if (options.has((OptionSpec)unpatchedO)) {
                    ConsoleTool.err("Connot specify --create/--dirty and --unpatched at the same time!");
                }
                List clean = options.valuesOf((OptionSpec)cleanO);
                List dirty = options.valuesOf((OptionSpec)createO);
                List prefixes = options.valuesOf((OptionSpec)prefixO);
                ConsoleTool.log("Generating: ");
                ConsoleTool.log("  Output:  " + output);
                ConsoleTool.log("  Pack200: " + pack200);
                ConsoleTool.log("  Legacy:    " + legacy);
                Generator gen = new Generator(output).pack200(pack200).legacy(legacy);
                if (clean.size() > 1 || dirty.size() > 1 || prefixes.size() > 1) {
                    if (clean.size() != dirty.size() || dirty.size() != prefixes.size()) {
                        ConsoleTool.log("When specifying multiple patchsets, you must have the same number of --clean, --dirty, and --prefix arguments");
                        int max = Math.max(clean.size(), Math.max(dirty.size(), prefixes.size()));
                        for (int x = 0; x < max; ++x) {
                            ConsoleTool.log("Set #" + x + ':');
                            ConsoleTool.log("  Prefix: " + (x < prefixes.size() ? (String)prefixes.get(x) : null));
                            ConsoleTool.log("  Clean:  " + (x < clean.size() ? (File)clean.get(x) : null));
                            ConsoleTool.log("  Dirty:  " + (x < dirty.size() ? (File)dirty.get(x) : null));
                        }
                        ConsoleTool.err("Unbalanced patchset arguments, see log for details");
                    }
                    for (int x = 0; x < clean.size(); ++x) {
                        ConsoleTool.log("  " + (String)prefixes.get(x));
                        ConsoleTool.log("    Clean: " + clean.get(x));
                        ConsoleTool.log("    Dirty: " + dirty.get(x));
                        gen.addSet((File)clean.get(x), (File)dirty.get(x), (String)prefixes.get(x));
                    }
                } else if (!prefixes.isEmpty()) {
                    ConsoleTool.log("  " + (String)prefixes.get(0));
                    ConsoleTool.log("    Clean: " + clean.get(0));
                    ConsoleTool.log("    Dirty: " + dirty.get(0));
                    gen.addSet((File)clean.get(0), (File)dirty.get(0), (String)prefixes.get(0));
                } else {
                    ConsoleTool.log("  Clean: " + clean.get(0));
                    ConsoleTool.log("  Dirty: " + dirty.get(0));
                    gen.addSet((File)clean.get(0), (File)dirty.get(0), null);
                }
                if (options.has((OptionSpec)patchesO)) {
                    for (File dir : options.valuesOf((OptionSpec)patchesO)) {
                        ConsoleTool.log("  Patches: " + dir);
                        gen.loadPatches(dir);
                    }
                }
                if (options.has((OptionSpec)srgO)) {
                    for (File file : options.valuesOf((OptionSpec)srgO)) {
                        ConsoleTool.log("  SRG:     " + file);
                        gen.loadMappings(file);
                    }
                }
                gen.create();
            } else if (options.has((OptionSpec)applyO)) {
                File clean_jar = (File)options.valueOf((OptionSpec)cleanO);
                if (options.has((OptionSpec)srgO)) {
                    ConsoleTool.err("Connot specify --apply and --srg at the same time!");
                }
                if (options.has((OptionSpec)patchesO)) {
                    ConsoleTool.err("Connot specify --apply and --patches at the same time!");
                }
                Patcher patcher = new Patcher(clean_jar, output).keepData(options.has((OptionSpec)dataO)).includeUnpatched(options.has((OptionSpec)unpatchedO)).pack200(pack200).legacy(legacy);
                ConsoleTool.log("Applying: ");
                ConsoleTool.log("  Clean:     " + clean_jar);
                ConsoleTool.log("  Output:    " + output);
                ConsoleTool.log("  KeepData:  " + options.has((OptionSpec)dataO));
                ConsoleTool.log("  Unpatched: " + options.has((OptionSpec)unpatchedO));
                ConsoleTool.log("  Pack200:   " + pack200);
                ConsoleTool.log("  Legacy:    " + legacy);
                List patches = options.valuesOf((OptionSpec)applyO);
                List prefixes = options.valuesOf((OptionSpec)prefixO);
                if (!prefixes.isEmpty() && patches.size() != prefixes.size()) {
                    ConsoleTool.err("Patches and prefixes arguments must be paird if they are used together. Use NULL to specify an empty prefix.");
                }
                for (int x = 0; x < patches.size(); ++x) {
                    patcher.loadPatches((File)patches.get(x), x >= prefixes.size() || "NULL".equals(prefixes.get(x)) ? null : (String)prefixes.get(x));
                }
                patcher.process();
            } else {
                parser.printHelpOn((OutputStream)System.out);
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }

    public static void log(String message) {
        System.out.println(message);
    }

    public static void err(String message) {
        System.out.println(message);
        throw new IllegalStateException(message);
    }
}

