/*
 * Decompiled with CFR 0.152.
 */
package com.kreezcraft.localizedchat;

import com.kreezcraft.localizedchat.ConfigCache;
import com.kreezcraft.localizedchat.Constants;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public class ForgeChatConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Constants.LOGGER.debug("Loaded Localized Chat's config file {}", (Object)configEvent.getConfig().getFileName());
        ConfigCache.updateCache();
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Constants.LOGGER.debug("Localized Chat's config just got changed on the file system!");
        ConfigCache.updateCache();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.IntValue talkRange;
        public final ForgeConfigSpec.IntValue shoutTalkRange;
        public final ForgeConfigSpec.IntValue shoutFoodCost;
        public final ForgeConfigSpec.BooleanValue opAsPlayer;
        public final ForgeConfigSpec.ConfigValue<? extends String> prefix;
        public final ForgeConfigSpec.BooleanValue usePrefix;
        public final ForgeConfigSpec.BooleanValue rangeNotifier;
        public final ForgeConfigSpec.ConfigValue<? extends String> bracketColor;
        public final ForgeConfigSpec.ConfigValue<? extends String> angleBraceColor;
        public final ForgeConfigSpec.ConfigValue<? extends String> posColor;
        public final ForgeConfigSpec.ConfigValue<? extends String> nameColor;
        public final ForgeConfigSpec.ConfigValue<? extends String> bodyColor;
        public final ForgeConfigSpec.ConfigValue<? extends String> defaultColor;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment(new String[]{"Chat Restrictions", "talkRange doesn't have a toggle value, because then the mod would be useless"}).push("restrictions");
            this.talkRange = builder.comment(new String[]{"The maximum range at which a player local to another player can be heard without requiring being an op.", "Default: 100"}).defineInRange("talkRange", 100, 0, Integer.MAX_VALUE);
            this.shoutTalkRange = builder.comment(new String[]{"The maximum range at which a player local to another player can be heard when shouting.", "Default: 400"}).defineInRange("shoutTalkRange", 400, 0, Integer.MAX_VALUE);
            this.shoutFoodCost = builder.comment(new String[]{"The amount of hunger used when shouting. Set to 0 to disable.", "Default: 1"}).defineInRange("shoutFoodCost", 1, 0, Integer.MAX_VALUE);
            this.opAsPlayer = builder.comment(new String[]{"Set to true to treat operators like players. Aka talking hits the entire world", "Default: false"}).define("opAsPlayer", false);
            builder.pop();
            builder.comment("Miscellaneous").push("miscellaneous");
            this.prefix = builder.comment("If alternate prefix is enabled then the distance won't be displayed but this prefix will.").define("prefix", (Object)"", o -> o instanceof String);
            this.usePrefix = builder.comment("Enable to use the prefix you set above").define("usePrefix", false);
            this.rangeNotifier = builder.comment("Should the distance away be indicated in the chat? This also disables the custom prefix.").define("rangeNotifier", true);
            builder.pop();
            builder.comment(new String[]{"These codes control the output of the colors sent to the client for the various parts of the mod", "Color codes reference at http://minecraft.wikia.com/wiki/Formatting_Codes"}).push("color_codes");
            this.bracketColor = builder.comment("Sets the color for brackets []").define("bracketColor", (Object)"\u00a76", o -> o instanceof String);
            this.angleBraceColor = builder.comment("Sets the color for angle braces <>").define("angleBraceColor", (Object)"\u00a77", o -> o instanceof String);
            this.posColor = builder.comment("Sets the color for positional information").define("posColor", (Object)"\u00a7e", o -> o instanceof String);
            this.nameColor = builder.comment("Sets the color to be used player names").define("nameColor", (Object)"\u00a7f", o -> o instanceof String);
            this.bodyColor = builder.comment("Sets the color the body of the message").define("bodyColor", (Object)"\u00a7f", o -> o instanceof String);
            this.defaultColor = builder.comment("The color to use when no other color will do").define("defaultColor", (Object)"\u00a7f", o -> o instanceof String);
            builder.pop();
        }
    }
}

