/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CsvRow;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringJoiner;

public final class NamedCsvRow {
    private final long originalLineNumber;
    private final Map<String, String> fieldMap;

    NamedCsvRow(Set<String> header, CsvRow row) {
        this.originalLineNumber = row.getOriginalLineNumber();
        this.fieldMap = new LinkedHashMap<String, String>(header.size());
        int i = 0;
        for (String h : header) {
            this.fieldMap.put(h, row.getField(i++));
        }
    }

    public long getOriginalLineNumber() {
        return this.originalLineNumber;
    }

    public String getField(String name) {
        String val = this.fieldMap.get(name);
        if (val == null) {
            throw new NoSuchElementException("No element with name '" + name + "' found. Valid names are: " + this.fieldMap.keySet());
        }
        return val;
    }

    public Map<String, String> getFields() {
        return Collections.unmodifiableMap(this.fieldMap);
    }

    public String toString() {
        return new StringJoiner(", ", NamedCsvRow.class.getSimpleName() + "[", "]").add("originalLineNumber=" + this.originalLineNumber).add("fieldMap=" + this.fieldMap).toString();
    }
}

