/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.distantfriends.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mrbysco.distantfriends.config.FriendNamesCache;
import com.mrbysco.distantfriends.entity.goal.LookedAtGoal;
import com.mrbysco.distantfriends.registry.FriendSerializers;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class DistantFriend
extends PathfinderMob {
    private static final EntityDataAccessor<Optional<GameProfile>> GAMEPROFILE = SynchedEntityData.m_135353_(DistantFriend.class, (EntityDataSerializer)((EntityDataSerializer)FriendSerializers.OPTIONAL_GAME_PROFILE.get()));
    private static final EntityDataAccessor<Boolean> DATA_IN_VIEW = SynchedEntityData.m_135353_(DistantFriend.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_LOOKED_AT = SynchedEntityData.m_135353_(DistantFriend.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private final TargetingConditions findPlayerCondition = TargetingConditions.m_148353_().m_26883_(16.0);
    private boolean isSlim = false;

    public DistantFriend(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GAMEPROFILE, Optional.empty());
        this.f_19804_.m_135372_(DATA_IN_VIEW, (Object)false);
        this.f_19804_.m_135372_(DATA_LOOKED_AT, (Object)false);
    }

    public Optional<GameProfile> getGameProfile() {
        return (Optional)this.f_19804_.m_135370_(GAMEPROFILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGameProfile(GameProfile playerProfile) {
        SkullBlockEntity.m_155738_((GameProfile)playerProfile, profile -> {
            this.f_19804_.m_135381_(GAMEPROFILE, Optional.of(profile));
            this.setSlim(profile != null && profile.getId() != null && this.isSlimSkin(profile.getId()));
        });
        DistantFriend distantFriend = this;
        synchronized (distantFriend) {
            this.getGameProfile().ifPresent(profile -> {
                if (this.f_19853_ != null && this.f_19853_.f_46443_ && profile != null && profile.isComplete()) {
                    Minecraft.m_91087_().m_91109_().m_118817_(profile, (textureType, textureLocation, profileTexture) -> {
                        if (textureType.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                            String metadata = profileTexture.getMetadata("model");
                            this.setSlim(metadata != null && metadata.equals("slim"));
                        }
                    }, true);
                }
            });
        }
    }

    public boolean isSlimSkin(UUID playerUUID) {
        return (playerUUID.hashCode() & 1) == 1;
    }

    public void setSlim(boolean slim) {
        this.isSlim = slim;
    }

    public boolean isSlim() {
        return this.isSlim;
    }

    public boolean isLookedAt() {
        return (Boolean)this.f_19804_.m_135370_(DATA_LOOKED_AT);
    }

    public void setLookedAt(boolean lookedAt) {
        this.f_19804_.m_135381_(DATA_LOOKED_AT, (Object)lookedAt);
    }

    public boolean isInView() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IN_VIEW);
    }

    public void setInView(boolean inView) {
        this.f_19804_.m_135381_(DATA_IN_VIEW, (Object)inView);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new LookedAtGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 128.0f, 0.75f, false));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 32.0f, 1.0, 1.33, EntitySelector.f_20408_::test));
        this.f_21345_.m_25352_(6, (Goal)new StrollWhenOutOfSight(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 35.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 3.0);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public Iterable<ItemStack> m_6167_() {
        return this.handItems;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot slotIn) {
        return switch (slotIn.m_20743_()) {
            default -> throw new IncompatibleClassChangeError();
            case EquipmentSlot.Type.HAND -> (ItemStack)this.handItems.get(slotIn.m_20749_());
            case EquipmentSlot.Type.ARMOR -> (ItemStack)this.armorItems.get(slotIn.m_20749_());
        };
    }

    public void m_8061_(EquipmentSlot equipmentSlot, ItemStack stack) {
        this.m_181122_(stack);
        switch (equipmentSlot.m_20743_()) {
            case HAND: {
                this.m_238392_(equipmentSlot, (ItemStack)this.handItems.set(equipmentSlot.m_20749_(), (Object)stack), stack);
                break;
            }
            case ARMOR: {
                this.m_238392_(equipmentSlot, (ItemStack)this.armorItems.set(equipmentSlot.m_20749_(), (Object)stack), stack);
            }
        }
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_7350_(EntityDataAccessor<?> key) {
        if (GAMEPROFILE.equals(key)) {
            DistantFriend distantFriend = this;
            synchronized (distantFriend) {
                this.getGameProfile().ifPresent(profile -> {
                    if (this.f_19853_ != null && this.f_19853_.f_46443_ && profile != null && profile.isComplete()) {
                        Minecraft.m_91087_().m_91109_().m_118817_(profile, (textureType, textureLocation, profileTexture) -> {
                            if (textureType.equals((Object)MinecraftProfileTexture.Type.SKIN)) {
                                String metadata = profileTexture.getMetadata("model");
                                this.setSlim(metadata != null && metadata.equals("slim"));
                            }
                        }, true);
                    }
                });
            }
        }
        super.m_7350_(key);
    }

    public boolean m_20177_(Player player) {
        if (player.m_142582_((Entity)this) && this.f_19797_ < 100) {
            return true;
        }
        return super.m_20177_(player);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        this.m_146870_();
        return super.m_6469_(source, amount);
    }

    public void m_8107_() {
        if (this.f_19797_ > 80 && this.f_19797_ % 20 == 0 && !this.f_19853_.m_45955_(this.findPlayerCondition, (LivingEntity)this, this.m_20191_().m_82377_(16.0, 32.0, 16.0)).isEmpty()) {
            for (int i = 0; i < 20; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
            }
            this.m_146870_();
        }
        super.m_8107_();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("inView", this.isInView());
        tag.m_128379_("lookedAt", this.isLookedAt());
        tag.m_128379_("gameProfileExists", ((Optional)this.f_19804_.m_135370_(GAMEPROFILE)).isPresent());
        if (this.getGameProfile().isPresent()) {
            tag.m_128365_("gameProfile", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)((GameProfile)((Optional)this.f_19804_.m_135370_(GAMEPROFILE)).get())));
        }
    }

    public void m_20258_(CompoundTag compound) {
        super.m_20258_(compound);
        this.setInView(compound.m_128471_("inView"));
        this.setLookedAt(compound.m_128471_("lookedAt"));
        this.f_19804_.m_135381_(GAMEPROFILE, !compound.m_128471_("gameProfileExists") ? Optional.empty() : Optional.ofNullable(NbtUtils.m_129228_((CompoundTag)compound.m_128469_("gameProfile"))));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(level, difficultyIn, reason, spawnDataIn, dataTag);
        List<String> friends = FriendNamesCache.nameList;
        if (!friends.isEmpty()) {
            String name = friends.get(this.f_19796_.m_188503_(friends.size()));
            this.setGameProfile(new GameProfile((UUID)null, name));
            this.getGameProfile().ifPresent(profile -> this.m_6593_((Component)Component.m_237113_((String)profile.getName())));
        }
        return data;
    }

    public boolean isLookingAtMe(Player player) {
        Vec3 vec3 = player.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(this.m_20185_() - player.m_20185_(), this.m_20188_() - player.m_20188_(), this.m_20189_() - player.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && player.m_142582_((Entity)this);
    }

    public static boolean checkFriendSpawn(EntityType<? extends DistantFriend> entityType, ServerLevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return levelAccessor.m_46791_() != Difficulty.PEACEFUL && DistantFriend.isDarkEnoughToSpawn(levelAccessor, pos, random) && DistantFriend.m_217057_(entityType, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor levelAccessor, BlockPos pos, RandomSource random) {
        if (levelAccessor.m_45517_(LightLayer.SKY, pos) > random.m_188503_(32)) {
            return false;
        }
        if (levelAccessor.m_45517_(LightLayer.BLOCK, pos) > 0) {
            return false;
        }
        int i = levelAccessor.m_6018_().m_46470_() ? levelAccessor.m_46849_(pos, 10) : levelAccessor.m_46803_(pos);
        return i <= random.m_188503_(8);
    }

    static class StrollWhenOutOfSight
    extends WaterAvoidingRandomStrollGoal {
        private final DistantFriend friend;

        public StrollWhenOutOfSight(DistantFriend friend) {
            super((PathfinderMob)friend, 1.0);
            this.friend = friend;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.friend.isInView();
        }
    }
}

