/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.util;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.jeryn.angels.common.entity.angel.AbstractWeepingAngel;
import dev.jeryn.angels.util.forge.ViewUtilImpl;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class ViewUtil {
    private static final float headSize = 0.15f;

    public static boolean isInFrontOfEntity(LivingEntity entity, Entity target, boolean vr) {
        Vec3 vecTargetsPos = target.m_20182_();
        Vec3 vecLook = entity.m_20154_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (vr) {
                vecLook = ViewUtil.manipulateVrRotation(player, entity.m_20154_());
            }
        }
        Vec3 vecFinal = vecTargetsPos.m_82505_(new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_())).m_82541_();
        vecFinal = new Vec3(vecFinal.f_82479_, 0.0, vecFinal.f_82481_);
        return vecFinal.m_82526_(vecLook) < 0.0;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Vec3 manipulateVrRotation(Player player, Vec3 vec3) {
        void var1_1;
        return ViewUtilImpl.manipulateVrRotation(player, (Vec3)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Vec3 manipulateVrPosition(Player player, Vec3 vec3) {
        void var1_1;
        return ViewUtilImpl.manipulateVrPosition(player, (Vec3)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isVrPlayer(Player player) {
        return ViewUtilImpl.isVrPlayer(player);
    }

    public static boolean isInSight(LivingEntity livingBase, AbstractWeepingAngel angel) {
        if (ViewUtil.isPlayerBlind(livingBase)) {
            return false;
        }
        if (ViewUtil.viewBlocked(livingBase, (LivingEntity)angel)) {
            return false;
        }
        if (livingBase instanceof Player) {
            Player player = (Player)livingBase;
            return ViewUtil.isInFrontOfEntity(livingBase, (Entity)angel, ViewUtil.isVrPlayer(player));
        }
        return ViewUtil.isInFrontOfEntity(livingBase, (Entity)angel, false);
    }

    public static boolean viewBlocked(LivingEntity viewer, LivingEntity angel) {
        AABB viewerBoundBox = viewer.m_20191_();
        AABB angelBoundingBox = angel.m_20191_();
        Vec3[] viewerPoints = new Vec3[]{new Vec3(viewerBoundBox.f_82288_, viewerBoundBox.f_82289_, viewerBoundBox.f_82290_), new Vec3(viewerBoundBox.f_82288_, viewerBoundBox.f_82289_, viewerBoundBox.f_82293_), new Vec3(viewerBoundBox.f_82288_, viewerBoundBox.f_82292_, viewerBoundBox.f_82290_), new Vec3(viewerBoundBox.f_82288_, viewerBoundBox.f_82292_, viewerBoundBox.f_82293_), new Vec3(viewerBoundBox.f_82291_, viewerBoundBox.f_82292_, viewerBoundBox.f_82290_), new Vec3(viewerBoundBox.f_82291_, viewerBoundBox.f_82292_, viewerBoundBox.f_82293_), new Vec3(viewerBoundBox.f_82291_, viewerBoundBox.f_82289_, viewerBoundBox.f_82293_), new Vec3(viewerBoundBox.f_82291_, viewerBoundBox.f_82289_, viewerBoundBox.f_82290_)};
        if (viewer instanceof Player) {
            Player player = (Player)viewer;
            Vec3 pos2 = new Vec3(viewer.m_20185_(), viewer.m_20186_() + (double)1.62f, viewer.m_20189_());
            if (ViewUtil.isVrPlayer(player)) {
                pos2 = ViewUtil.manipulateVrPosition(player, pos2);
            }
            viewerPoints[0] = pos2.m_82520_((double)-0.15f, (double)-0.15f, (double)-0.15f);
            viewerPoints[1] = pos2.m_82520_((double)-0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[2] = pos2.m_82520_((double)-0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[3] = pos2.m_82520_((double)-0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[4] = pos2.m_82520_((double)0.15f, (double)0.15f, (double)-0.15f);
            viewerPoints[5] = pos2.m_82520_((double)0.15f, (double)0.15f, (double)0.15f);
            viewerPoints[6] = pos2.m_82520_((double)0.15f, (double)-0.15f, (double)0.15f);
            viewerPoints[7] = pos2.m_82520_((double)0.15f, (double)-0.15f, (double)-0.15f);
        }
        Vec3[] angelPoints = new Vec3[]{new Vec3(angelBoundingBox.f_82288_, angelBoundingBox.f_82289_, angelBoundingBox.f_82290_), new Vec3(angelBoundingBox.f_82288_, angelBoundingBox.f_82289_, angelBoundingBox.f_82293_), new Vec3(angelBoundingBox.f_82288_, angelBoundingBox.f_82292_, angelBoundingBox.f_82290_), new Vec3(angelBoundingBox.f_82288_, angelBoundingBox.f_82292_, angelBoundingBox.f_82293_), new Vec3(angelBoundingBox.f_82291_, angelBoundingBox.f_82292_, angelBoundingBox.f_82290_), new Vec3(angelBoundingBox.f_82291_, angelBoundingBox.f_82292_, angelBoundingBox.f_82293_), new Vec3(angelBoundingBox.f_82291_, angelBoundingBox.f_82289_, angelBoundingBox.f_82293_), new Vec3(angelBoundingBox.f_82291_, angelBoundingBox.f_82289_, angelBoundingBox.f_82290_)};
        for (int i = 0; i < viewerPoints.length; ++i) {
            if (viewer.f_19853_.m_45547_(new ClipContext(viewerPoints[i], angelPoints[i], ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)viewer)).m_6662_() == HitResult.Type.MISS) {
                return false;
            }
            if (ViewUtil.rayTraceBlocks(viewer, viewer.f_19853_, viewerPoints[i], angelPoints[i], pos -> {
                BlockState state = viewer.f_19853_.m_8055_(pos);
                return !ViewUtil.canSeeThrough(state, viewer.f_19853_, pos);
            }) != null) continue;
            return false;
        }
        if (angel.f_19797_ % 1200 == 0 && angel.m_20270_((Entity)viewer) < 15.0f) {
            viewer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 15));
        }
        return true;
    }

    public static boolean isDarkForPlayer(AbstractWeepingAngel angel, LivingEntity living) {
        return !living.m_21023_(MobEffects.f_19611_) && angel.f_19853_.m_7146_(angel.m_20183_()) <= 0 && !angel.f_19853_.m_6042_().f_63856_();
    }

    public static boolean isPlayerBlind(LivingEntity living) {
        return living.m_21023_(MobEffects.f_19610_);
    }

    private static HitResult rayTraceBlocks(LivingEntity livingEntity, Level world, Vec3 vec31, Vec3 vec32, Predicate<BlockPos> stopOn) {
        if (!(Double.isNaN(vec31.f_82479_) || Double.isNaN(vec31.f_82480_) || Double.isNaN(vec31.f_82481_) || Double.isNaN(vec32.f_82479_) || Double.isNaN(vec32.f_82480_) || Double.isNaN(vec32.f_82481_))) {
            BlockHitResult raytraceresult;
            int j1;
            int i1;
            int i = Mth.m_14107_((double)vec32.f_82479_);
            int j = Mth.m_14107_((double)vec32.f_82480_);
            int k = Mth.m_14107_((double)vec32.f_82481_);
            int l = Mth.m_14107_((double)vec31.f_82479_);
            BlockPos blockpos = new BlockPos(l, i1 = Mth.m_14107_((double)vec31.f_82480_), j1 = Mth.m_14107_((double)vec31.f_82481_));
            if (stopOn.test(blockpos) && (raytraceresult = world.m_45547_(new ClipContext(vec31, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity))) != null) {
                return raytraceresult;
            }
            int k1 = 200;
            while (k1-- >= 0) {
                BlockHitResult raytraceresult1;
                Direction enumfacing;
                if (Double.isNaN(vec31.f_82479_) || Double.isNaN(vec31.f_82480_) || Double.isNaN(vec31.f_82481_)) {
                    return null;
                }
                if (l == i && i1 == j && j1 == k) {
                    return null;
                }
                boolean flag2 = true;
                boolean flag = true;
                boolean flag1 = true;
                double d0 = 999.0;
                double d1 = 999.0;
                double d2 = 999.0;
                if (i > l) {
                    d0 = (double)l + 1.0;
                } else if (i < l) {
                    d0 = (double)l + 0.0;
                } else {
                    flag2 = false;
                }
                if (j > i1) {
                    d1 = (double)i1 + 1.0;
                } else if (j < i1) {
                    d1 = (double)i1 + 0.0;
                } else {
                    flag = false;
                }
                if (k > j1) {
                    d2 = (double)j1 + 1.0;
                } else if (k < j1) {
                    d2 = (double)j1 + 0.0;
                } else {
                    flag1 = false;
                }
                double d3 = 999.0;
                double d4 = 999.0;
                double d5 = 999.0;
                double d6 = vec32.f_82479_ - vec31.f_82479_;
                double d7 = vec32.f_82480_ - vec31.f_82480_;
                double d8 = vec32.f_82481_ - vec31.f_82481_;
                if (flag2) {
                    d3 = (d0 - vec31.f_82479_) / d6;
                }
                if (flag) {
                    d4 = (d1 - vec31.f_82480_) / d7;
                }
                if (flag1) {
                    d5 = (d2 - vec31.f_82481_) / d8;
                }
                if (d3 == -0.0) {
                    d3 = -1.0E-4;
                }
                if (d4 == -0.0) {
                    d4 = -1.0E-4;
                }
                if (d5 == -0.0) {
                    d5 = -1.0E-4;
                }
                if (d3 < d4 && d3 < d5) {
                    enumfacing = i > l ? Direction.WEST : Direction.EAST;
                    vec31 = new Vec3(d0, vec31.f_82480_ + d7 * d3, vec31.f_82481_ + d8 * d3);
                } else if (d4 < d5) {
                    enumfacing = j > i1 ? Direction.DOWN : Direction.UP;
                    vec31 = new Vec3(vec31.f_82479_ + d6 * d4, d1, vec31.f_82481_ + d8 * d4);
                } else {
                    enumfacing = k > j1 ? Direction.NORTH : Direction.SOUTH;
                    vec31 = new Vec3(vec31.f_82479_ + d6 * d5, vec31.f_82480_ + d7 * d5, d2);
                }
                if (!stopOn.test(blockpos = new BlockPos(l = Mth.m_14107_((double)vec31.f_82479_) - (enumfacing == Direction.EAST ? 1 : 0), i1 = Mth.m_14107_((double)vec31.f_82480_) - (enumfacing == Direction.UP ? 1 : 0), j1 = Mth.m_14107_((double)vec31.f_82481_) - (enumfacing == Direction.SOUTH ? 1 : 0))) || (raytraceresult1 = world.m_45547_(new ClipContext(vec31, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)livingEntity))) == null) continue;
                return raytraceresult1;
            }
        }
        return null;
    }

    public static boolean canSeeThrough(BlockState blockState, Level world, BlockPos pos) {
        if (!blockState.m_60815_() || !blockState.m_60804_((BlockGetter)world, pos)) {
            return true;
        }
        Block block = blockState.m_60734_();
        if (block instanceof DoorBlock) {
            return blockState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER;
        }
        if (!block.m_49966_().m_60815_()) {
            return true;
        }
        return blockState.m_60812_((BlockGetter)world, pos) == Shapes.m_83040_();
    }
}

