/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.util;

import com.google.common.collect.Lists;
import dev.jeryn.angels.WAConfiguration;
import dev.jeryn.angels.WeepingAngels;
import dev.jeryn.angels.common.WASounds;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class Teleporter {
    public static ServerLevel getRandomDimension(RandomSource rand, ServerLevel serverLevel) {
        MinecraftServer server = serverLevel.m_7654_();
        Iterable dimensions = server.m_129785_();
        ArrayList allowedDimensions = Lists.newArrayList((Iterable)dimensions);
        for (ServerLevel dimension : dimensions) {
            for (String dimName : (List)WAConfiguration.CONFIG.bannedDimensions.get()) {
                if (!dimension.m_46472_().m_135782_().toString().equalsIgnoreCase(dimName)) continue;
                allowedDimensions.remove(dimension);
            }
        }
        allowedDimensions.remove(server.m_129880_(Level.f_46429_));
        return (ServerLevel)allowedDimensions.get(rand.m_188503_(allowedDimensions.size()));
    }

    public static BlockPos findClosestValidPosition(ServerLevel level, BlockPos position) {
        ChunkPos chunkPos = level.m_46865_(position).m_7697_();
        int maxBuildHeight = level.m_151558_();
        int minHeight = level.m_141937_();
        ArrayList<BlockPos> solutionsInRow = new ArrayList<BlockPos>();
        level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, true);
        BlockPos closest = BlockPos.f_121853_;
        if (Teleporter.canPlaceTardis(level, position) && Teleporter.isExitPositionSafe(level, position)) {
            solutionsInRow.add(position);
        }
        if (!solutionsInRow.isEmpty()) {
            closest = position;
        } else {
            List<BlockPos> nextValidLocations = Teleporter.findValidLocationInColumn(level, position, minHeight, maxBuildHeight);
            if (!nextValidLocations.isEmpty()) {
                solutionsInRow.addAll(nextValidLocations);
            } else {
                List<BlockPos> surroundingPositionsSameYLevel = Teleporter.getBlockPosInRadius(position, 1, true, false);
                for (BlockPos directionOffset : surroundingPositionsSameYLevel) {
                    BlockPos nextLocation = directionOffset;
                    if (!Teleporter.canPlaceTardis(level, nextLocation) || !Teleporter.isExitPositionSafe(level, nextLocation)) continue;
                    solutionsInRow.add(nextLocation);
                }
                if (solutionsInRow.isEmpty()) {
                    List<BlockPos> surroundingPositionsForColumn = Teleporter.getBlockPosInRadius(position, 6, true, true);
                    for (BlockPos pos : surroundingPositionsForColumn) {
                        List<BlockPos> surroundingColumn = Teleporter.findValidLocationInColumn(level, pos, minHeight, maxBuildHeight);
                        if (surroundingColumn.isEmpty()) continue;
                        solutionsInRow.addAll(surroundingColumn);
                    }
                }
            }
            closest = Teleporter.findClosestValidPositionFromTarget(solutionsInRow, position);
        }
        level.m_8602_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        return closest;
    }

    public static List<BlockPos> getBlockPosInRadius(BlockPos referencePoint, int radius, boolean interCardinal, boolean includeReferencePoint) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        ArrayList horizontalDirections = new ArrayList();
        horizontalDirections.addAll(Direction.Plane.HORIZONTAL.m_122557_().toList());
        for (Direction dir : horizontalDirections) {
            BlockPos offsettedPos = referencePoint.m_5484_(dir, radius);
            posList.add(offsettedPos);
            if (!interCardinal) continue;
            BlockPos interCardinalPos = offsettedPos.m_121955_(dir.m_122427_().m_122436_());
            posList.add(interCardinalPos);
        }
        if (includeReferencePoint) {
            posList.add(referencePoint);
        }
        return posList;
    }

    public static List<BlockPos> findValidLocationInColumn(ServerLevel level, BlockPos position, int minHeight, int maxBuildHeight) {
        ArrayList<BlockPos> solutionsInRow = new ArrayList<BlockPos>();
        List<BlockPos> blockColumn = Teleporter.getBlockPosColumn(position, minHeight, maxBuildHeight);
        List<BlockPos> filteredForAir = blockColumn.stream().filter(x -> Teleporter.isLegalLandingBlock(level, x)).toList();
        List<BlockPos> filteredForNonAir = blockColumn.stream().filter(x -> !Teleporter.isLegalLandingBlock(level, x)).toList();
        for (BlockPos airPos : filteredForAir) {
            if (level.m_46472_() == Level.f_46429_ && airPos.m_123342_() > 125) continue;
            BlockPos below = airPos.m_7495_();
            BlockPos above = airPos.m_7494_();
            if (!filteredForNonAir.contains(below) || !filteredForAir.contains(above) || !Teleporter.canPlaceTardis(level, airPos) || !Teleporter.isExitPositionSafe(level, airPos)) continue;
            solutionsInRow.add(airPos);
        }
        return solutionsInRow;
    }

    public static boolean isExitPositionSafe(ServerLevel level, BlockPos pos) {
        return Teleporter.isLegalLandingBlock(level, pos.m_7494_()) && Teleporter.isLegalLandingBlock(level, pos) && !Teleporter.isLegalLandingBlock(level, pos.m_7495_());
    }

    private static boolean canPlaceTardis(ServerLevel targetLevel, BlockPos pos) {
        return targetLevel.m_46472_() == Level.f_46429_ && pos.m_123342_() <= 125;
    }

    public static boolean isLegalLandingBlock(ServerLevel level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        return state.m_60795_() || state.m_60819_().m_76178_() && !state.m_60838_((BlockGetter)level, pos);
    }

    private static BlockPos findClosestValidPositionFromTarget(List<BlockPos> validPositions, BlockPos targetLocation) {
        int distance = Integer.MAX_VALUE;
        BlockPos intendedLocation = targetLocation;
        BlockPos closestSolution = BlockPos.f_121853_;
        for (BlockPos potentialLocation : validPositions) {
            int distanceBetween = Math.abs(potentialLocation.m_123333_((Vec3i)intendedLocation));
            if (distanceBetween >= distance) continue;
            distance = distanceBetween;
            closestSolution = potentialLocation;
        }
        return closestSolution;
    }

    private static List<BlockPos> getBlockPosColumn(BlockPos referencePoint, int min, int max) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        for (int i = min; i <= max; ++i) {
            positions.add(new BlockPos(referencePoint.m_123341_(), i, referencePoint.m_123343_()));
        }
        return positions;
    }

    private static boolean canTeleportTo(BlockPos pPos, Level level, Entity entity) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)level, (BlockPos.MutableBlockPos)pPos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos blockpos = pPos.m_121996_((Vec3i)entity.m_20183_());
        return level.m_45756_(entity, entity.m_20191_().m_82338_(blockpos));
    }

    public static boolean performTeleport(Entity pEntity, ServerLevel pLevel, int pX, int pY, int pZ, float pYaw, float pPitch, boolean playSound) {
        WeepingAngels.LOGGER.debug("Teleported {} to {} {} {}", new Object[]{pEntity.m_5446_().getString(), pX, pY, pZ});
        BlockPos blockpos = new BlockPos(pX, pY, pZ);
        if (!Teleporter.canTeleportTo(blockpos, (Level)pLevel, pEntity)) {
            return false;
        }
        if (!Level.m_46741_((BlockPos)blockpos)) {
            return false;
        }
        float f = Mth.m_14177_((float)pYaw);
        float f1 = Mth.m_14177_((float)pPitch);
        if (pEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pEntity;
            if (playSound) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(WASounds.TELEPORT.get(), SoundSource.MASTER, (double)pX, (double)pY, (double)pZ, 0.25f, 1.0f, serverPlayer.f_19853_.f_46441_.m_188505_()));
            }
            ChunkPos chunkpos = new ChunkPos(new BlockPos(pX, pY, pZ));
            pLevel.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)pEntity.m_19879_());
            pEntity.m_8127_();
            if (serverPlayer.m_5803_()) {
                serverPlayer.m_6145_(true, true);
            }
            if (pLevel == pEntity.f_19853_) {
                serverPlayer.f_8906_.m_9774_((double)pX, (double)pY, (double)pZ, f, f1);
            } else {
                serverPlayer.m_8999_(pLevel, (double)pX, (double)pY, (double)pZ, f, f1);
            }
            pEntity.m_5616_(f);
        } else {
            float f2 = Mth.m_14036_((float)f1, (float)-90.0f, (float)90.0f);
            if (pLevel == pEntity.f_19853_) {
                pEntity.m_7678_((double)pX, (double)pY, (double)pZ, f, f2);
                pEntity.m_5616_(f);
            } else {
                pEntity.m_19877_();
                Entity entity = pEntity;
                pEntity = pEntity.m_6095_().m_20615_((Level)pLevel);
                if (pEntity == null) {
                    return false;
                }
                pEntity.m_20361_(entity);
                pEntity.m_7678_((double)pX, (double)pY, (double)pZ, f, f2);
                pEntity.m_5616_(f);
                entity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                pLevel.m_143334_(pEntity);
            }
        }
        if (!(pEntity instanceof LivingEntity) || !((LivingEntity)pEntity).m_21255_()) {
            pEntity.m_20256_(pEntity.m_20184_().m_82542_(1.0, 0.0, 1.0));
            pEntity.m_6853_(true);
        }
        if (pEntity instanceof PathfinderMob) {
            ((PathfinderMob)pEntity).m_21573_().m_26573_();
        }
        return true;
    }
}

