/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.network.messages;

import dev.jeryn.angels.common.blockentity.StatueBlockEntity;
import dev.jeryn.angels.common.entity.angel.ai.AngelEmotion;
import dev.jeryn.angels.common.entity.angel.ai.AngelVariant;
import dev.jeryn.angels.network.MessageC2S;
import dev.jeryn.angels.network.MessageType;
import dev.jeryn.angels.network.WANetwork;
import dev.jeryn.angels.util.Platform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class UpdateStatueMessage
extends MessageC2S {
    private ResourceKey<Level> level;
    private BlockPos blockPos;
    private AngelVariant angelVariant;
    private AngelEmotion angelEmotion;
    private int pose;

    public UpdateStatueMessage(AngelVariant angelVariant, AngelEmotion angelEmotion, int pose, BlockPos blockPos, ResourceKey<Level> resourceKey) {
        this.angelEmotion = angelEmotion;
        this.angelVariant = angelVariant;
        this.pose = pose;
        this.blockPos = blockPos;
        this.level = resourceKey;
    }

    public UpdateStatueMessage(FriendlyByteBuf buf) {
        this.angelEmotion = AngelEmotion.find(buf.m_130277_());
        this.angelVariant = AngelVariant.getVariant(buf.m_130281_());
        this.pose = buf.readInt();
        this.blockPos = buf.m_130135_();
        this.level = buf.m_236801_(Registry.f_122819_);
    }

    @Override
    @NotNull
    public MessageType getType() {
        return WANetwork.UPDATE_STATUE;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.angelEmotion.getId());
        buf.m_130085_(this.angelVariant.location());
        buf.writeInt(this.pose);
        buf.m_130064_(this.blockPos);
        buf.m_236858_(this.level);
    }

    @Override
    public void handle() {
        ServerLevel mcLevel = Platform.getServer().m_129880_(this.level);
        BlockEntity blockEntity = mcLevel.m_7702_(this.blockPos);
        if (blockEntity instanceof StatueBlockEntity) {
            StatueBlockEntity statueBlockEntity = (StatueBlockEntity)blockEntity;
            statueBlockEntity.setAnimation(this.pose);
            statueBlockEntity.setSpecificVariant(this.angelVariant);
            statueBlockEntity.setEmotion(this.angelEmotion);
            statueBlockEntity.sendUpdates();
            mcLevel.m_142346_(null, GameEvent.f_157792_, this.blockPos);
        }
    }
}

