/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.jeryn.angels.network.Message;
import dev.jeryn.angels.network.MessageC2S;
import dev.jeryn.angels.network.MessageS2C;
import dev.jeryn.angels.network.MessageType;
import dev.jeryn.angels.network.forge.NetworkManagerImpl;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class NetworkManager {
    protected final ResourceLocation channelName;
    protected final Map<String, MessageType> toServer = new HashMap<String, MessageType>();
    protected final Map<String, MessageType> toClient = new HashMap<String, MessageType>();

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static NetworkManager create(ResourceLocation channelName) {
        return NetworkManagerImpl.create(channelName);
    }

    public NetworkManager(ResourceLocation channelName) {
        this.channelName = channelName;
    }

    public MessageType registerS2C(String id, MessageDecoder<MessageS2C> decoder) {
        MessageType msgType = new MessageType(id, this, decoder, false);
        this.toClient.put(id, msgType);
        return msgType;
    }

    public MessageType registerC2S(String id, MessageDecoder<MessageC2S> decoder) {
        MessageType msgType = new MessageType(id, this, decoder, true);
        this.toServer.put(id, msgType);
        return msgType;
    }

    public abstract void sendToServer(MessageC2S var1);

    public abstract void sendToPlayer(ServerPlayer var1, MessageS2C var2);

    public void sendToDimension(Level level, MessageS2C message) {
        if (!level.f_46443_) {
            for (Player player : level.m_6907_()) {
                this.sendToPlayer((ServerPlayer)player, message);
            }
        }
    }

    @FunctionalInterface
    public static interface MessageDecoder<T extends Message> {
        public T decode(FriendlyByteBuf var1);
    }
}

