/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.forge.handlers;

import dev.jeryn.angels.client.models.ModelRegistration;
import dev.jeryn.angels.client.models.forge.ModelRegistrationImpl;
import dev.jeryn.angels.client.render.blockentity.CoffinRenderer;
import dev.jeryn.angels.client.render.blockentity.GeneratorRenderer;
import dev.jeryn.angels.client.render.blockentity.SnowAngelRenderer;
import dev.jeryn.angels.client.render.blockentity.StatueRenderer;
import dev.jeryn.angels.client.render.entity.ThrowableGeneratorRenderer;
import dev.jeryn.angels.client.render.entity.WeepingAngelRenderer;
import dev.jeryn.angels.client.render.entity.layers.DonationWingsLayer;
import dev.jeryn.angels.common.WAEntities;
import dev.jeryn.angels.common.blockentity.WABlockEntities;
import dev.jeryn.angels.common.blocks.WABlocks;
import dev.jeryn.angels.common.items.WAItems;
import dev.jeryn.angels.donators.DonationChecker;
import dev.jeryn.angels.forge.overlays.TimeyWimeyOverlay;
import dev.jeryn.angels.util.WAHelper;
import java.util.List;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="weeping_angels", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientModBus {
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onRenderOverlay(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("angel", (IGuiOverlay)new TimeyWimeyOverlay());
    }

    @SubscribeEvent
    public static void renderLayers(EntityRenderersEvent.AddLayers addLayers) {
        addLayers.getSkins().forEach(skin -> {
            LivingEntityRenderer renderer = addLayers.getSkin(skin);
            renderer.m_115326_(new DonationWingsLayer(renderer));
        });
    }

    @SubscribeEvent
    public static void event(EntityRenderersEvent.RegisterLayerDefinitions event) {
        ModelRegistration.init();
        ModelRegistrationImpl.register(event);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_(WABlockEntities.COFFIN.get(), CoffinRenderer::new);
        BlockEntityRenderers.m_173590_(WABlockEntities.STATUE.get(), StatueRenderer::new);
        BlockEntityRenderers.m_173590_(WABlockEntities.GENERATOR.get(), GeneratorRenderer::new);
        BlockEntityRenderers.m_173590_(WABlockEntities.SNOW_ANGEL.get(), SnowAngelRenderer::new);
        ItemBlockRenderTypes.setRenderLayer((Block)WABlocks.COFFIN.get(), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)WABlocks.STATUE.get(), (RenderType)RenderType.m_110463_());
        DonationChecker.checkForUpdate(true);
        ItemProperties.register((Item)WAItems.TIMEY_WIMEY_DETECTOR.get(), (ResourceLocation)new ResourceLocation("weeping_angels", "time"), (ItemPropertyFunction)new CompassItemPropertyFunction((clientLevel, itemStack, entity) -> {
            List<Entity> anomaliesAround = WAHelper.getAnomaliesAroundEntity(entity, 64);
            if (anomaliesAround.isEmpty()) {
                return null;
            }
            return GlobalPos.m_122643_((ResourceKey)entity.f_19853_.m_46472_(), (BlockPos)anomaliesAround.get(0).m_20183_());
        }));
    }

    @SubscribeEvent
    public static void entityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer(WAEntities.WEEPING_ANGEL.get(), WeepingAngelRenderer::new);
        event.registerEntityRenderer(WAEntities.GENERATOR.get(), ThrowableGeneratorRenderer::new);
    }
}

