/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.forge.handlers;

import com.mojang.blaze3d.shaders.FogShape;
import dev.jeryn.angels.common.CatacombTracker;
import dev.jeryn.angels.donators.DonationChecker;
import dev.jeryn.angels.donators.Donator;
import dev.jeryn.angels.util.ClientUtil;
import dev.jeryn.angels.util.WAHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="weeping_angels", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ClientBus {
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent clientTickEvent) {
        DonationChecker.checkForUpdate(false);
    }

    @SubscribeEvent
    public static void onPlayerJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ClientUtil.playDectorSound(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(LivingEvent.LivingTickEvent tickEvent) {
        LivingEntity livingEntity = tickEvent.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            for (Donator donator : DonationChecker.getModDonators()) {
                if (!player.m_20149_().equals(donator.getUuid())) continue;
                donator.tick(player);
            }
        }
    }

    @SubscribeEvent
    public static void onSetupFogDensity(ViewportEvent.RenderFog event) {
        if (Minecraft.m_91087_().f_91073_ != null && CatacombTracker.isInCatacomb()) {
            event.setCanceled(true);
            event.setNearPlaneDistance(-8.0f);
            event.setFarPlaneDistance(30.0f);
            event.setFogShape(FogShape.SPHERE);
        }
    }

    @SubscribeEvent
    public static void onSetupFogColor(ViewportEvent.ComputeFogColor event) {
        if (Minecraft.m_91087_().f_91073_ != null && CatacombTracker.isInCatacomb()) {
            event.setRed((float)WAHelper.fogColor().f_82479_);
            event.setGreen((float)WAHelper.fogColor().f_82480_);
            event.setBlue((float)WAHelper.fogColor().f_82481_);
        }
    }
}

