/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.data.forge;

import com.mojang.datafixers.util.Pair;
import dev.jeryn.angels.common.blocks.WABlocks;
import dev.jeryn.angels.registry.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.ChestLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class LootProvider
extends LootTableProvider {
    public LootProvider(DataGenerator pGenerator) {
        super(pGenerator);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
        return List.of(Pair.of(ModBlockLoot::new, (Object)LootContextParamSets.f_81421_), Pair.of(ModChestLoot::new, (Object)LootContextParamSets.f_81411_));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationContext) {
        for (Map.Entry<ResourceLocation, LootTable> entry : map.entrySet()) {
            LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)entry.getKey(), (LootTable)entry.getValue());
        }
    }

    public static class ModChestLoot
    extends ChestLoot {
        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> biConsumer) {
        }
    }

    public static class ModBlockLoot
    extends BlockLoot {
        protected void addTables() {
            this.m_124288_(WABlocks.CHRONODYNE_GENERATOR.get());
            this.m_124288_(WABlocks.COFFIN.get());
            this.m_124288_(WABlocks.STATUE.get());
            this.m_124288_(WABlocks.SNOW_ANGEL.get());
            this.m_124288_(WABlocks.PLINTH.get());
        }

        protected Iterable<Block> getKnownBlocks() {
            ArrayList<Block> blocks = new ArrayList<Block>();
            for (RegistrySupplier<Block> entry : WABlocks.BLOCKS.getEntries()) {
                blocks.add(entry.get());
            }
            return blocks;
        }
    }
}

