/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.common.blockentity;

import dev.jeryn.angels.common.blockentity.CoffinType;
import dev.jeryn.angels.common.blockentity.StatueBlockEntity;
import dev.jeryn.angels.common.blockentity.WABlockEntities;
import dev.jeryn.angels.common.blocks.CoffinBlock;
import dev.jeryn.angels.common.blocks.StatueBaseBlock;
import dev.jeryn.angels.common.entity.angel.WeepingAngel;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CoffinBlockEntity
extends BlockEntity
implements BlockEntityTicker<CoffinBlockEntity> {
    private CoffinType coffinType = null;
    public AnimationState COFFIN_OPEN = new AnimationState();
    public AnimationState COFFIN_CLOSE = new AnimationState();
    public int animationTimer = 0;
    private boolean isDemat = false;
    private boolean needsBox = false;
    private int ticks;
    private int pulses;
    private float alpha = 1.0f;

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void sendUpdates() {
        if (this.f_58857_ != null && this.m_58900_() != null && this.m_58900_().m_60734_() != null) {
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
            this.f_58857_.m_7260_(this.f_58858_, this.f_58857_.m_8055_(this.f_58858_), this.f_58857_.m_8055_(this.f_58858_), 3);
        }
        this.m_6596_();
    }

    public CoffinBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(WABlockEntities.COFFIN.get(), pPos, pBlockState);
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState, CoffinBlockEntity pBlockEntity) {
        if (pLevel.m_5776_()) {
            ++this.animationTimer;
            if (this.isOpen()) {
                if (!this.COFFIN_OPEN.m_216984_()) {
                    this.COFFIN_CLOSE.m_216973_();
                    this.COFFIN_OPEN.m_216977_(this.animationTimer);
                }
            } else if (!this.COFFIN_CLOSE.m_216984_()) {
                this.COFFIN_OPEN.m_216973_();
                this.COFFIN_CLOSE.m_216977_(this.animationTimer);
            }
        }
        if (this.needsBox) {
            this.needsBox = false;
            this.setCoffinType(CoffinType.randomTardis(this.f_58857_.f_46441_));
        }
        if (this.isDemat && this.coffinType.isTardis()) {
            this.alpha = this.ticks % 60 < 30 ? (this.pulses <= 2 ? (float)((double)this.alpha - 0.01) : (float)((double)this.alpha - 0.02)) : (float)((double)this.alpha + 0.01);
            if (this.ticks % 60 == 0) {
                ++this.pulses;
            }
            ++this.ticks;
            if (this.ticks >= 360 && !this.f_58857_.f_46443_) {
                int j;
                this.f_58857_.m_7471_(this.f_58858_, false);
                this.activateAngels(40);
                for (int i = 25; i > 0; i -= j) {
                    j = ExperienceOrb.m_20782_((int)i);
                    this.f_58857_.m_7967_((Entity)new ExperienceOrb(this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), j));
                }
            }
        }
    }

    private void activateAngels(int range) {
        Iterator iterator = BlockPos.m_121985_((BlockPos)this.f_58858_, (int)range, (int)range, (int)range).iterator();
        while (iterator.hasNext()) {
            BlockEntity blockEntity;
            BlockPos pos = (BlockPos)iterator.next();
            ServerLevel serverWorld = (ServerLevel)this.f_58857_;
            if (this.f_58857_.m_46791_() == Difficulty.PEACEFUL || !((blockEntity = serverWorld.m_7702_(pos)) instanceof StatueBlockEntity)) continue;
            StatueBlockEntity statueBlockEntity = (StatueBlockEntity)blockEntity;
            WeepingAngel angel = new WeepingAngel(this.f_58857_);
            angel.setVariant(statueBlockEntity.getVariant());
            angel.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, (float)Math.toRadians(22.5f * (float)((Integer)statueBlockEntity.m_58900_().m_61143_((Property)StatueBaseBlock.ROTATION)).intValue()), 0.0f);
            this.f_58857_.m_7967_((Entity)angel);
            this.f_58857_.m_7471_(pos, false);
        }
    }

    public boolean isOpen() {
        BlockState state = this.f_58857_.m_8055_(this.m_58899_());
        if (state.m_61138_((Property)CoffinBlock.OPEN)) {
            return (Boolean)state.m_61143_((Property)CoffinBlock.OPEN);
        }
        return false;
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.setCoffinType(CoffinType.find(pTag.m_128461_("coffinType")));
        this.alpha = pTag.m_128457_("alpha");
        this.isDemat = pTag.m_128471_("isDemat");
        this.needsBox = pTag.m_128471_("needsBox");
    }

    protected void m_183515_(CompoundTag pTag) {
        super.m_183515_(pTag);
        pTag.m_128359_("coffinType", this.getCoffinType().getId());
        pTag.m_128379_("isDemat", this.isDemat);
        pTag.m_128350_("alpha", this.alpha);
        pTag.m_128379_("needsBox", this.needsBox);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CoffinType getCoffinType() {
        if (this.coffinType == null) {
            this.coffinType = CoffinType.randomCoffin(RandomSource.m_216327_());
            this.sendUpdates();
        }
        return this.coffinType;
    }

    public void setCoffinType(CoffinType coffinType) {
        this.coffinType = coffinType;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void demat() {
        this.isDemat = true;
    }
}

