/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.client.render.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.jeryn.angels.client.models.MercyWingsModel;
import dev.jeryn.angels.client.models.ModelRegistration;
import dev.jeryn.angels.client.models.entity.angel.AliceAngelModel;
import dev.jeryn.angels.client.models.entity.angel.AngelModel;
import dev.jeryn.angels.common.entity.angel.ai.AngelEmotion;
import dev.jeryn.angels.common.entity.angel.ai.AngelVariant;
import dev.jeryn.angels.donators.DonationChecker;
import dev.jeryn.angels.donators.Donator;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import org.jetbrains.annotations.NotNull;

public class DonationWingsLayer<T extends LivingEntity, M extends HumanoidModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public final MercyWingsModel mercyWings;
    public final AngelModel angelModel;
    private final ResourceLocation TEXTURE_LIGHTMAP = new ResourceLocation("weeping_angels", "textures/entity/wings/mercy_wings_lightmap.png");

    public DonationWingsLayer(RenderLayerParent<T, M> renderLayerParent) {
        super(renderLayerParent);
        this.mercyWings = new MercyWingsModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelRegistration.MERCY_WINGS));
        this.angelModel = new AliceAngelModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelRegistration.ALICE_ANGEL));
    }

    public static Optional<Donator> getDonatorData(Player player) {
        for (Donator person : DonationChecker.getModDonators()) {
            if (!player.m_20149_().equals(person.getUuid())) continue;
            return Optional.of(person);
        }
        return Optional.empty();
    }

    public void render(@NotNull PoseStack poseStack, @NotNull MultiBufferSource multiBufferSource, int pPackedLight, T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        if (pLivingEntity.m_20177_((Player)Minecraft.m_91087_().f_91074_)) {
            return;
        }
        if (pLivingEntity instanceof Player) {
            Player player = (Player)pLivingEntity;
            DonationWingsLayer.getDonatorData(player).ifPresent(data -> {
                if (player.m_36170_(PlayerModelPart.CAPE)) {
                    return;
                }
                if (data.getWings().equalsIgnoreCase("mercy")) {
                    poseStack.m_85836_();
                    ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
                    this.mercyWings.setupAnim((LivingEntity)player, 0.0f, 0.0f, player.f_19797_, 0.0f, 0.0f);
                    this.mercyWings.m_7695_(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)MercyWingsModel.texture(AngelEmotion.IDLE, AngelVariant.STONE))), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    this.mercyWings.setupAnim((LivingEntity)player, 0.0f, 0.0f, player.f_19797_, 0.0f, 0.0f);
                    this.mercyWings.m_7695_(poseStack, multiBufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)this.TEXTURE_LIGHTMAP)), 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 0.5f);
                    poseStack.m_85849_();
                    return;
                }
                poseStack.m_85836_();
                ((HumanoidModel)this.m_117386_()).f_102810_.m_104299_(poseStack);
                poseStack.m_85837_(0.0, 0.5, 0.0);
                for (ModelPart wing : this.angelModel.getWings()) {
                    wing.m_104306_(poseStack, multiBufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.angelModel.texture(AngelEmotion.IDLE, AngelVariant.getVariant(new ResourceLocation(data.getVariant()))))), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                poseStack.m_85849_();
            });
        }
    }
}

