/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.client.render.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.jeryn.angels.client.models.ModelRegistration;
import dev.jeryn.angels.client.models.entity.angel.AliceAngelModel;
import dev.jeryn.angels.client.models.entity.angel.AngelModel;
import dev.jeryn.angels.client.render.entity.layers.AngelItemLayer;
import dev.jeryn.angels.client.render.entity.layers.WeepingAngelCrackinessLayer;
import dev.jeryn.angels.common.entity.angel.WeepingAngel;
import dev.jeryn.angels.common.entity.angel.ai.AngelVariant;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class WeepingAngelRenderer
extends LivingEntityRenderer<WeepingAngel, AngelModel> {
    private AngelVariant textureVariant = AngelVariant.STONE;

    public WeepingAngelRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AliceAngelModel(context.m_174023_(ModelRegistration.ALICE_ANGEL)), 0.0f);
        this.m_115326_(new WeepingAngelCrackinessLayer((RenderLayerParent<WeepingAngel, AngelModel>)this));
        this.m_115326_(new AngelItemLayer((RenderLayerParent<WeepingAngel, AngelModel>)this));
    }

    public void render(WeepingAngel pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        Item item;
        this.textureVariant = pEntity.getVariant();
        this.f_115290_ = this.getModel();
        if (pEntity.f_20919_ > 0 && (item = this.textureVariant.getDrops().m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (pEntity.f_20919_ < 10) {
                for (int i = 0; i < 10; ++i) {
                    pEntity.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockItem.m_40614_().m_49966_()), pEntity.m_20185_(), pEntity.m_20186_() + 1.0, pEntity.m_20189_(), 0.0, 0.1, 0.2);
                }
            }
            for (int i = 0; i < 10; ++i) {
                pEntity.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, blockItem.m_40614_().m_49966_()), pEntity.m_20185_(), pEntity.m_20186_(), pEntity.m_20189_(), 0.0, 0.1, 0.2);
            }
            return;
        }
        super.m_7392_((LivingEntity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @Nullable
    protected RenderType getRenderType(WeepingAngel pLivingEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        return pGlowing ? RenderType.m_110491_((ResourceLocation)this.getTextureLocation(pLivingEntity)) : RenderType.m_110470_((ResourceLocation)this.getTextureLocation(pLivingEntity));
    }

    public AngelModel getModel() {
        return ModelRegistration.getModelFor(this.textureVariant);
    }

    protected void setupRotations(WeepingAngel pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        if (pEntityLiving.f_20919_ > 0) {
            return;
        }
        super.m_7523_((LivingEntity)pEntityLiving, pMatrixStack, pAgeInTicks, pRotationYaw, pPartialTicks);
    }

    public ResourceLocation getTextureLocation(WeepingAngel weepingAngel) {
        AngelVariant variant = weepingAngel.getVariant();
        return this.getModel().texture(weepingAngel.getEmotion(), variant);
    }

    protected boolean shouldShowName(WeepingAngel weepingAngel) {
        return false;
    }
}

