/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import dev.jeryn.angels.client.models.ModelRegistration;
import dev.jeryn.angels.client.models.blockentity.GeneratorModel;
import dev.jeryn.angels.client.models.blockentity.PortalModel;
import dev.jeryn.angels.common.blockentity.GeneratorBlockEntity;
import dev.jeryn.angels.common.blocks.GeneratorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GeneratorRenderer
implements BlockEntityRenderer<GeneratorBlockEntity>,
BlockEntityRendererProvider<GeneratorBlockEntity> {
    private static final ResourceLocation GENERATOR_TEX = new ResourceLocation("weeping_angels", "textures/entity/generator/vortex_generator.png");
    private static final ResourceLocation GENERATOR_ACTIVATED_TEX = new ResourceLocation("weeping_angels", "textures/entity/generator/vortex_generator_armed.png");
    private static final ResourceLocation VORTEX_TEX = new ResourceLocation("weeping_angels", "textures/entity/generator/vortex.png");
    private final PortalModel vortexModel;
    private final GeneratorModel generatorModel;

    public GeneratorRenderer(BlockEntityRendererProvider.Context context) {
        this.vortexModel = new PortalModel(context.m_173582_(ModelRegistration.PORTAL));
        this.generatorModel = new GeneratorModel(context.m_173582_(ModelRegistration.GENERATOR));
    }

    public void render(GeneratorBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        BlockState blockstate = blockEntity.m_58900_();
        float rotation = 22.5f * (float)((Integer)blockstate.m_61143_((Property)GeneratorBlock.ROTATION)).intValue();
        if (blockEntity.hasSpawned() && blockEntity.isActivated()) {
            poseStack.m_85837_(0.5, (double)-0.3f, 0.5);
            poseStack.m_85841_(2.0f, 0.3f, 2.0f);
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_((float)(Minecraft.m_91087_().f_91074_.f_19797_ * 20)));
            this.vortexModel.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)VORTEX_TEX)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        } else {
            poseStack.m_85837_(0.5, 1.5, 0.5);
            poseStack.m_85845_(Vector3f.f_122223_.m_122240_(180.0f));
            poseStack.m_85845_(Vector3f.f_122225_.m_122240_(rotation));
            this.generatorModel.animateTile(blockEntity);
            this.generatorModel.m_7695_(poseStack, bufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)(blockEntity.isActivated() ? GENERATOR_ACTIVATED_TEX : GENERATOR_TEX))), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        poseStack.m_85849_();
    }

    public BlockEntityRenderer<GeneratorBlockEntity> m_173570_(BlockEntityRendererProvider.Context context) {
        return new GeneratorRenderer(context);
    }
}

