/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels.client.models.entity.angel;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.angels.client.models.entity.angel.AliceAngelModel;
import dev.jeryn.angels.client.models.entity.angel.AngelModel;
import dev.jeryn.angels.client.screen.ChiselScreen;
import dev.jeryn.angels.common.blockentity.StatueBlockEntity;
import dev.jeryn.angels.common.entity.angel.WeepingAngel;
import dev.jeryn.angels.common.entity.angel.ai.AngelEmotion;
import dev.jeryn.angels.common.entity.angel.ai.AngelVariant;
import dev.jeryn.angels.donators.DonationChecker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class ADizzleAngelModel
extends AngelModel {
    private final ModelPart Angel;
    private final ModelPart root;
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public ADizzleAngelModel(ModelPart root) {
        this.root = root;
        this.Angel = root.m_171324_("Angel");
        this.leftWing = this.Angel.m_171324_("Body").m_171324_("leftWing");
        this.rightWing = this.Angel.m_171324_("Body").m_171324_("rightWing");
    }

    public static LayerDefinition meshLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Angel = partdefinition.m_171599_("Angel", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Body = Angel.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition leftArm = Body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(24, 19).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition rightArm = Body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(24, 19).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)-10.0f, (float)0.0f));
        PartDefinition head = Body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition leftWing = Body.m_171599_("leftWing", CubeListBuilder.m_171558_().m_171514_(40, 25).m_171488_(-0.5f, -2.5f, 0.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(46, 19).m_171488_(-0.5f, -3.5f, 2.0f, 1.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(58, 12).m_171488_(-0.5f, -3.5f, 4.0f, 1.0f, 18.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(52, 16).m_171488_(-0.5f, -1.5f, 6.0f, 1.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.5f, (float)-8.5f, (float)2.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition rightWing = Body.m_171599_("rightWing", CubeListBuilder.m_171558_().m_171514_(40, 25).m_171488_(-0.5f, -2.5f, 0.0f, 1.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(46, 19).m_171488_(-0.5f, -3.5f, 2.0f, 1.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(58, 12).m_171488_(-0.5f, -3.5f, 4.0f, 1.0f, 18.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(52, 16).m_171488_(-0.5f, -1.5f, 6.0f, 1.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.5f, (float)-8.5f, (float)2.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition Legs = Angel.m_171599_("Legs", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(0.0f, 7.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-6.0f, 7.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(24, 19).m_171488_(-4.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(24, 19).m_171480_().m_171488_(0.0f, 0.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    @Override
    public Iterable<ModelPart> getWings() {
        return ImmutableList.of((Object)this.rightWing, (Object)this.leftWing);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Angel.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    @Override
    public ModelPart getHead() {
        return this.Angel.m_171324_("Body").m_171324_("head");
    }

    @Override
    public ResourceLocation texture(AngelEmotion angelEmotion, AngelVariant angelVariant) {
        String seasonal = DonationChecker.isXmas() ? "_xmas" : "";
        return new ResourceLocation("weeping_angels", "textures/entity/angel/a_dizzle/variants/a_dizzle_" + angelEmotion.getId() + seasonal + ".png");
    }

    @Override
    public void animateTile(StatueBlockEntity statueBlockEntity) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.m_233381_(statueBlockEntity.getAnimationState(), this.poseForId(statueBlockEntity.getAnimation()), Minecraft.m_91087_().f_91074_.f_19797_);
    }

    @Override
    public AnimationDefinition poseForId(int index) {
        return ADizzleAngelModel.getAnimationDefinition(index);
    }

    public void setupAnim(WeepingAngel weepingAngel, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (weepingAngel.getFakeAnimation() != -1) {
            this.m_233385_(ChiselScreen.POSE_ANIMATION_STATE, ADizzleAngelModel.getAnimationDefinition(weepingAngel.getFakeAnimation()), Minecraft.m_91087_().f_91074_.f_19797_, 1000.0f);
            return;
        }
        int playbackSpeed = Mth.m_14045_((int)weepingAngel.f_19853_.f_46441_.m_188503_(7), (int)2, (int)7);
        if (ADizzleAngelModel.isBlockPosBehindPlayer((Player)Minecraft.m_91087_().f_91074_, weepingAngel.m_20183_()) || weepingAngel.isHooked() || weepingAngel.getSeenTime() > 0 || weepingAngel.f_19797_ < 200) {
            playbackSpeed = 0;
        }
        this.m_233385_(weepingAngel.POSE_ANIMATION_STATE, AliceAngelModel.ANIMATION_STREAM, weepingAngel.f_19797_, playbackSpeed);
    }
}

