/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.angels;

import com.google.common.collect.Lists;
import dev.jeryn.angels.util.HurtHelper;
import java.util.List;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class WAConfiguration {
    public static final WAConfiguration CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static Client CLIENT;
    public static ForgeConfigSpec CLIENT_SPEC;
    public final ForgeConfigSpec.IntValue stalkRange;
    public final ForgeConfigSpec.BooleanValue blockBreaking;
    public final ForgeConfigSpec.BooleanValue interdimensionalTeleporting;
    public final ForgeConfigSpec.BooleanValue angelTheft;
    public final ForgeConfigSpec.EnumValue<HurtHelper.HurtType> hurtType;
    public final ForgeConfigSpec.IntValue teleportRange;
    public final ForgeConfigSpec.IntValue teleportChance;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> bannedDimensions;

    public WAConfiguration(ForgeConfigSpec.Builder builder) {
        builder.push("behaviour").comment("This section determines the behaviour of the Weeping Angels.");
        this.stalkRange = builder.translation("config.weeping_angels.stalk_range").comment("Range for player visibility check.").defineInRange("stalk_range", 65, 1, 100);
        this.blockBreaking = builder.translation("config.weeping_angels.block_breaking").comment("Allow angels to break light-emitting blocks?").define("block_breaking", true);
        builder.pop();
        builder.push("damage");
        this.hurtType = builder.translation("config.weeping_angels.hurt_type").comment("Type of hurt inflicted by angels.").defineEnum("hurt_type", (Enum)HurtHelper.HurtType.PICKAXE_AND_GENERATOR);
        builder.pop();
        builder.push("teleporting");
        this.teleportRange = builder.translation("config.weeping_angels.teleport_range").comment("Range for teleportation.").defineInRange("teleport_range", 400, 1, Integer.MAX_VALUE);
        this.interdimensionalTeleporting = builder.translation("config.weeping_angels.interdimensional_teleporting").comment("Allow teleporting across dimensions?").define("interdimensional_teleporting", true);
        this.angelTheft = builder.translation("config.weeping_angels.angel_theft").comment("Allow Angel theft?").define("angel_theft", true);
        this.teleportChance = builder.translation("config.weeping_angels.teleport_chance").comment("Chance of teleportation occurring.").defineInRange("teleport_chance", 50, 1, 100);
        this.bannedDimensions = builder.translation("config.weeping_angels.banned_dimensions").comment("Dimensions where teleportation is banned.").defineList("banned_dimensions", (List)Lists.newArrayList((Object[])new String[]{Level.f_46430_.m_135782_().toString()}), String.class::isInstance);
        builder.pop();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(WAConfiguration::new);
        CONFIG = (WAConfiguration)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        Pair specClientPair = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specClientPair.getRight();
        CLIENT = (Client)specClientPair.getLeft();
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue santaHats;

        Client(ForgeConfigSpec.Builder builder) {
            builder.push("seasonal");
            this.santaHats = builder.translation("config.weeping_angels.santa_hats").comment("Show Santa hats on angels at Xmas?").define("santa_hats", true);
            builder.pop();
        }
    }
}

